package com.rocogz.syy.infrastructure.dto.samsung.resp;

import lombok.Data;

/**
 * <dl>
 * <dd>Description: 公共响应 dto</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-11-04 11:06:36</dd>
 * <dd>@author：Andy</dd>
 * </dl>
 */
@Data
public class GcdmCommonRespDto<T> {

    /** GCDM接口返回码类型-成功 **/
    public static final String RET_TYPE_S = "S";

    /** GCDM接口返回码类型-失败 **/
    public static final String RET_TYPE_E = "E";

    /** GCDM接口返回码类型-警告 **/
    public static final String RET_TYPE_W = "W";

    /** GCDM接口返回码类型-Information **/
    public static final String RET_TYPE_I = "I";

    /**
     * 响应码
     * E0001 请提供必输字段:
     * S0002 保存成功
     * E0003 保存失败
     * E0004 开始时间晚于结算时间
     * E0005 请输入会员ID或者IMEI
     * E0006 未找到数据
     * S0007 显示成功
     * E0008 该客户已经购买优惠卷
     * E0009 重复电池折扣券和Spen优惠券
     * E0011 会员信息错误，请检查会员号和SA ID是否正确
     */
    private String code;

    /**
     * 响应类型
     */
    private String type;

    /**
     * 响应消息
     */
    private String message;

    /**
     * 返回数据
     */
    private T data;
}
