package com.rocogz.syy.infrastructure.entity.samsung;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 三星接口请求记录表 entity</dd>
 * <dd>Company: 广州大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020-11-30 10:41:19</dd>
 * <dd>@author：Andy</dd>
 * <dd>@description：此对象参考日志跟踪</dd>
 * </dl>
 */
@Data
public class BasicSamsungInterfaceLog {

    /**
     * 核心编号：例如会员编号、手机号、优惠券码等,方便最快的定位问题
     */
    private String coreCode;

    /**
     * 请求路径
     */
    private String apiPath;

    /**
     * 请求参数
     */
    private String reqBody;

    /**
     * 响应状态
     */
    private String respStatus;

    /**
     * 响应消息
     */
    private String respMessage;

    /**
     * 响应结果
     */
    private String respBody;

    /**
     * 接口耗时
     */
    private Long spendMillis;

    /**
     * 调用开始时间
     */
    private LocalDateTime startTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;
}
