package com.rocogz.syy.infrastructure.entity.wechat;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.common.entity.VersionEntity;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2020/5/29 10:53</dd>
 * <dd>@author：</dd>
 * </dl>
 */
@Data
@TableName(value = "basic_wechat_open_userinfo")
public class WechatOpenUserinfo extends IdEntity {


    private String openId;

    /**
     * 昵称
     */
    private String nickName;

    /**
     * 性别 1是男性，2是女性，0是未知
     */
    private Integer sex;

    /**
     * 城市
     */
    private String city;

    /**
     * 省份
     */
    private String province;

    /**
     * 国家
     */
    private String country;

    /**
     * 头像
     */
    private String headImgUrl;

    /**
     * 用户全局唯一标识  unionid
     */
    private String unionid;

    /**
     * 用户全局唯一标识  unionid
     */
    private String token;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    protected LocalDateTime createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    protected LocalDateTime updateTime;
}