package com.rocogz.syy.infrastructure.entity.charge;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2021/1/4 下午3:12</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class BasicChargeInterfaceLog extends IdEntity {


    /**
     * 请求路径
     */
    private String apiPath;

    /**
     * 请求方式：get、post等
     */
    private String method;

    /**
     * 请求参数
     */
    private String requestBody;

    /**
     * 返回结果
     */
    private String responseBody;

    /**
     * 返回code
     */
    private String responseCode;
    /**
     * 返回message
     */
    private String responseMessage;
    /**
     * 接口调用耗时
     */
    private Long spendMillis;

    /**
     * 接口调用时间
     */
    private LocalDateTime invoiceTime;

}
