package com.rocogz.merchant.entity.insuranceGift;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 
 * </p>
 *
 * @author yifenrui
 * @since 2020-09-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("merchant_insurance_total_gift")
public class MerchantInsuranceTotalGift extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 编码
     */
    private String code;

    /**
     * 名称
     */
    private String name;

    /**
     * 类型
     */
    private String type;

    /**
     * 关联code
     */
    private String relateCode;

    /**
     * 成本价
     */
    private BigDecimal costPrice;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 销售价
     */
    private BigDecimal settlePrice;

    /**
     * 状态
     */
    private String status;


    /**
     * 排序
     */
    private Integer sort;

    /**
     * 数据类型 MERCHANT 商户端，CAROWNER 车主端
     */
    private String sourceType;



    @TableField(exist = false)
    private String typeStatus;

    @TableField(exist = false)
    private List<MerchantInsuranceTotalGiftRoleRelate> appointRoleList;

}
