package com.rocogz.merchant.entity.label;

import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <dl>
 * <dd>Description: 商户标签管理</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/10/27 10:43 上午</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class MerchantLabel extends UserTimeEntity {

    /**
     * 标签编号，字长5位，自动生成，不可修改
     */
    private String code;

    /**
     * 标签名称，字长20，除空格外不限字符，编辑可修改
     */
    private String name;

    /**
     * 标签说明
     */
    private String description;

    /**
     * 图片url
     */
    private String imgUrl;

    /**
     * 关联商品数量
     */
    private Integer goodsNum;

    /**
     * 状态：启用、停用
     */
    private String status;
}
