package com.rocogz.merchant.dto.goods;

import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <dl>
 * <dd>Description:虚拟卡查询请求dto </dd>
 * <dd>@date: 2020/08/23</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Getter
@Setter
public class GoodsVcardStockPageRequestDto {
    /**
     * 商品编码
     */
    private String goodsCode;

    /**
     * SKU编码
     */
    private String skuCode;

    /**
     * 卡号
     */
    private String cardNo;
    /**
     * 关联的订单号
     */
    private String orderNo;
    /**
     * 有效期查询开始时间 对应查询的是 effectEndDate
     */
    private LocalDateTime effectQueryStartDate;

    /**
     * 有效期查询结束时间 对应查询的是 effectEndDate
     */
    private LocalDateTime effectQueryEndDate;
    /**
     * 供应商编码集合
     */
    private List<String> supplierCodeList;
    /**
     * 卡密类型
     */
    private String cardType;
    /**
     * 查询的状态
     */
    private String status;

    /**
     * 因为卡券有个过期状态，在计划任务跑之前，
     * 页面展示的时候已经将未使用过期时间超过当前时间的调整为 已过期。
     * 但如果此时查询已过期，可能又查不到。解决这个问题暂时通过拦截status是不是查询的已过期的
     * 然后将 status，开启invalid 这个条件
     */
    private Boolean invalid;

    /**
     *  每页多少条
     */
    private int limit;
    /**
     * 第几页
     */
    private int page;
}
