package com.rocogz.merchant.entity.goods;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description:这家伙很懒 虚拟商品库存</dd>
 * <dd>@date: 2020/08/23</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
@TableName(value = "merchant_goods_vcard_stock")
public class MerchantGoodsVCardStock extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 批次号:UUID去掉
     */
    private String batchNo;

    @TableField(exist = false)
    private MerchantSku merchantSku;

    /**
     * 序号，导入时模版列
     */
    private String sno ;

    /**
     * 关联的订单编号
     */
    private String orderNo;

    /**
     * 商品编码
     */
    private String goodsCode;
    /**
     * 类型  CARD("卡号密码"), PASSWORD("卡密"), EXCHANGE("兑换码");
     */
    private String cardType;
    /**
     * 卡号
     */
    private String cardNo;
    /**
     * 卡密，（兑换码)
     */
    private String cardPwd;


    @TableField(exist = false)
    private String strEffectStartDate;

    /**
     * 有效期开始时间
     */
    private LocalDateTime effectStartDate;


    @TableField(exist = false)
    private String strEffectEndDate;

    /**
     *有效期结束时间
     */
    private LocalDateTime effectEndDate;

    /**
     * 未使用，已使用，过期，作废
     * 已过期：应该需要计划任务去做了
     * NOT_USED("未使用"), USED("已使用"), TO_VOID("已作废"); EXPIRED(已过期)
     */
    private String status;


}
