package com.rocogz.syy.operation.entity.qr;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 二维码扫码历史记录
 * </p>
 *
 * @author luoyc
 * @since 2020-09-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("operate_qr_scan_history")
public class OperateQrScanHistory extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 用户code
     */
    private String userCode;

    /**
     * 用户手机号
     */
    private String userMobile;

    /**
     * 用户小程序openid
     */
    private String wxOpenid;

    /**
     * 扫码时间
     */
    private LocalDateTime scanTime;

    /**
     * 扫码地址
     */
    private String scanAddress;

    /**
     * ip地址
     */
    private String ipAddress;

    /**
     * 二维码编码
     */
    private String qrCode;

    /**
     * 二维码名称
     */
    private String qrName;


}
