package com.rocogz.syy.operation.enums;

import lombok.Getter;

@Getter
public enum RateSettingEnum {

    INEFFECTIVE("INEFFECTIVE", "未生效"),
    EFFECTIVE("EFFECTIVE", "生效"),
    EXPIRED("EXPIRED", "过期"),
    INVALID("INVALID", "作废"),
    ;

    private String code;

    private String label;

    RateSettingEnum(String code, String label) {
        this.code = code;
        this.label = label;
    }

    public static String getLabel(String code) {
        for (RateSettingEnum values : values()) {
            if (values.getCode().equals(code)) {
                return values.getLabel();
            }
        }
        return null;
    }

}
