/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.operation.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.operation.dto.MerchantStoreQrDto;
import com.rocogz.syy.operation.dto.OperateIiuvQrDTO;
import com.rocogz.syy.operation.dto.OperateMsgTemplateDto;
import com.rocogz.syy.operation.dto.qr.OperateQrScanHistoryDTO;
import com.rocogz.syy.operation.entity.Approvement;
import com.rocogz.syy.operation.entity.OperateBanner;
import com.rocogz.syy.operation.entity.OperateBannerPrefecture;
import com.rocogz.syy.operation.entity.OperateColumn;
import com.rocogz.syy.operation.entity.OperateMsgTemplate;
import com.rocogz.syy.operation.entity.SystemMessage;
import com.rocogz.syy.operation.entity.opinion.OperateOpinion;
import com.rocogz.syy.operation.entity.qr.OperateIiuv;
import com.rocogz.syy.operation.entity.qr.OperateQr;
import com.rocogz.syy.operation.entity.qr.OperateQrConfig;
import com.rocogz.syy.operation.entity.qr.OperateQrParameter;
import com.rocogz.syy.operation.entity.qr.OperateQrScanHistory;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface IOperationClientService {
    @GetMapping(value={"/api/operation/approvement"})
    public PageTable<Approvement> searchApproment(@RequestParam(name="approveCode", required=false) String var1, @RequestParam(name="bussinessCode", required=false) String var2, @RequestParam(name="bussinessName", required=false) String var3, @RequestParam(name="bussinessType", required=false) String var4, @RequestParam(name="bussinessItem", required=false) String var5, @RequestParam(name="approved", defaultValue="false") Boolean var6, @RequestParam(name="limit", defaultValue="20") Integer var7, @RequestParam(name="page", defaultValue="1") Integer var8);

    @GetMapping(value={"/api/operation/approvement/findApprovement"})
    public Response<Approvement> findApprovement(@RequestParam(name="bussinessCode", required=false) String var1);

    @PostMapping(value={"/api/operation/approvement/create"})
    public Response<String> createApprovement(@RequestBody Approvement var1);

    @PostMapping(value={"/api/operation/approvement/update"})
    public Response<String> updateApprovement(@RequestBody Approvement var1);

    @PostMapping(value={"/api/operation/approvement/approve"})
    public Response<String> approveApprovement(@RequestBody Approvement var1);

    @GetMapping(value={"/api/operation/approvement/getBatchApprove"})
    public PageTable<Approvement> getBatchApprove(@RequestParam(name="approveCodes", required=false) String[] var1, @RequestParam(name="limit", defaultValue="20") Integer var2, @RequestParam(name="page", defaultValue="1") Integer var3);

    @GetMapping(value={"/api/operation/banner"})
    public PageTable<OperateBanner> findOperateBanner(@RequestParam(name="prefecturekeyword", required=false) String[] var1, @RequestParam(name="status", required=false) String var2, @RequestParam(name="showLocation", required=false) String var3, @RequestParam(name="linkType", required=false) String var4, @RequestParam(value="prefectureList", required=false) List<String> var5, @RequestParam(name="limit", defaultValue="20") int var6, @RequestParam(name="page", defaultValue="1") int var7);

    @PostMapping(value={"/api/operation/banner/createOrUpdateBanner"})
    public Response createOrUpdateBanner(@RequestBody OperateBanner var1);

    @PostMapping(value={"/api/operation/banner/deleteBanner"})
    public Response deleteBanner(@RequestParam(name="code") String var1);

    @PostMapping(value={"/api/operation/banner/status"})
    public Response switchBannerStatus(@RequestBody OperateBanner var1);

    @GetMapping(value={"/api/operation/banner/{id}"})
    public Response<OperateBanner> getOperateBannerById(@PathVariable(value="id") Integer var1);

    @PostMapping(value={"/api/operation/banner/findPrefectureByCode"})
    public Response<List<OperateBannerPrefecture>> findPrefectureListByCode(@RequestParam(name="code") String var1);

    @PostMapping(value={"/api/operation/banner/checkTitle"})
    public Response<List<OperateBanner>> checkTitle(@RequestParam(name="code", required=false) String var1, @RequestParam(name="title") String var2);

    @GetMapping(value={"/api/operation/banner/findIndexBanner"})
    public Response<List<OperateBanner>> findIndexBanner(@RequestParam(name="code") String var1);

    @GetMapping(value={"/api/operation/banner/findOilingBanner"})
    public Response<List<OperateBanner>> findOilingBanner(@RequestParam(name="code") String var1, @RequestParam(name="showLocation") String var2);

    @GetMapping(value={"/api/operation/column"})
    public PageTable<OperateColumn> searchColumn(@RequestParam(name="areaCodes", required=false) String[] var1, @RequestParam(name="name", required=false) String var2, @RequestParam(name="columnType", required=false) String var3, @RequestParam(name="status", required=false) String var4, @RequestParam(value="prefectureList", required=false) List<String> var5, @RequestParam(name="limit", defaultValue="20") Integer var6, @RequestParam(name="page", defaultValue="1") Integer var7);

    @PostMapping(value={"/api/operation/column/statusOrSort"})
    public Response switchColumnStatusOrSort(@RequestBody OperateColumn var1);

    @PostMapping(value={"/api/operation/column/deleteColumn"})
    public Response deleteColumn(@RequestParam(name="code") String var1);

    @PostMapping(value={"/api/operation/column/createOrUpdateColumn"})
    public Response createOrUpdateColumn(@RequestBody OperateColumn var1);

    @GetMapping(value={"/api/operation/column/{id}"})
    public Response<OperateColumn> getOperateColumnById(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/api/operation/column/findIndexOperateColumn"})
    public Response<List<OperateColumn>> findIndexOperateColumn(@RequestParam(name="prefectureCode") String var1);

    @GetMapping(value={"/api/operation/systemMessage"})
    public PageTable<SystemMessage> findSystemMessageList(@RequestParam(value="title", required=false) String var1, @RequestParam(value="sendStatus", required=false) String var2, @RequestParam(value="showPlace", required=false) String var3, @RequestParam(value="limit", defaultValue="20") int var4, @RequestParam(value="page", defaultValue="1") int var5);

    @PostMapping(value={"/api/operation/systemMessage/saveOrUpdateSystemMessage"})
    public Response saveOrUpdateSystemMessage(@RequestBody SystemMessage var1);

    @PostMapping(value={"/api/operation/systemMessage/changeSystemMessageSendStatus"})
    public Response changeSystemMessageSendStatus(@RequestBody SystemMessage var1);

    @GetMapping(value={"/api/operation/systemMessage/copySystemMessage/{id}"})
    public Response copySystemMessage(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/api/operation/systemMessage/deleteSystemMessageById/{id}"})
    public Response deleteSystemMessageById(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/api/operation/systemMessage/getSystemMessageById/{id}"})
    public Response<SystemMessage> getSystemMessageById(@PathVariable(value="id") Integer var1);

    @GetMapping(value={"/api/operation/systemMessage/getSystemMessageByCode/{code}"})
    public Response<SystemMessage> getSystemMessageByCode(@PathVariable(value="code") String var1);

    @GetMapping(value={"/api/operation/systemMessage/pageSystemMessageListByPrefectureCode"})
    public PageTable<SystemMessage> pageSystemMessageListByPrefectureCode(@RequestParam(value="prefectureCode") String var1, @RequestParam(value="showPlace") String var2, @RequestParam(value="limit", defaultValue="20") int var3, @RequestParam(value="page", defaultValue="1") int var4);

    @GetMapping(value={"/api/operation/systemMessage/findSystemMessageListByPrefectureCode"})
    public Response<List<SystemMessage>> findSystemMessageListByPrefectureCode(@RequestParam(value="prefectureCode") String var1, @RequestParam(value="showPlace") String var2);

    @GetMapping(value={"/api/operation/msg/template/findMsgTemplateList"})
    public PageTable<OperateMsgTemplate> findMsgTemplateList(@RequestParam(value="templateCode", required=false) String var1, @RequestParam(value="templateTitle", required=false) String var2, @RequestParam(value="limit", defaultValue="20") int var3, @RequestParam(value="page", defaultValue="1") int var4);

    @PostMapping(value={"/api/operation/msg/template/saveOrUpdateMsgTemplate"})
    public Response saveOrUpdateMsgTemplate(@RequestBody OperateMsgTemplate var1);

    @GetMapping(value={"/api/operation/msg/template/deleteMsgTemplateByTemplateCode/{templateCode}"})
    public Response deleteMsgTemplateByTemplateCode(@PathVariable(value="templateCode") String var1);

    @GetMapping(value={"/api/operation/msg/template/findMsgTemplateByTemplateCode/{templateCode}"})
    public Response<OperateMsgTemplate> findMsgTemplateByTemplateCode(@PathVariable(value="templateCode") String var1);

    @PutMapping(value={"/api/operation/msg/template/sendTemplateMsgToUser"})
    public Response sendTemplateMsgToUser(@RequestBody OperateMsgTemplateDto var1);

    @GetMapping(value={"api/operation/iiuv/queryPage"})
    public PageTable<OperateIiuv> operateIiuvPageTable(@RequestParam(value="iiuvCode", required=false) String var1, @RequestParam(value="iiuvName", required=false) String var2, @RequestParam(value="iiuvType", required=false) String var3, @RequestParam(value="page", defaultValue="1") Integer var4, @RequestParam(value="limit", defaultValue="20") Integer var5);

    @PostMapping(value={"api/operation/iiuv/save"})
    public Response operateIiuvSave(@RequestBody OperateIiuv var1);

    @PostMapping(value={"/api/operation/iiuv/saveByStoreCode"})
    public Response<String> operateIiuvSaveByStoreCode(@RequestParam(value="storeCode") String var1, @RequestParam(value="storeName") String var2, @RequestParam(value="type") String var3, @RequestBody UserTimeEntity var4);

    @GetMapping(value={"api/operation/iiuv/deleteByCode"})
    public Response operateIiuvDeleteByCode(@RequestParam(value="iiuvCode") String var1);

    @PostMapping(value={"api/operation/iiuv/genrate"})
    public Response operateIiuvGenrate(@RequestBody OperateIiuv var1);

    @PostMapping(value={"api/operation/iiuv/batchGenrate"})
    public Response operateIiuvBatchGenrate(@RequestBody List<OperateIiuv> var1);

    @GetMapping(value={"api/operation/iiuv/operateIiuvListByCodes"})
    public Response<List<OperateIiuv>> operateIiuvListByCodes(@RequestParam(value="iiuvCodes") String[] var1);

    @GetMapping(value={"api/operation/iiuv/detailByCode"})
    public Response<OperateIiuv> operateIiuvDetail(@RequestParam(value="iiuvCode") String var1);

    @GetMapping(value={"api/operation/qrconfig/getByType"})
    public Response<OperateQrConfig> operateQrConfigByType(@RequestParam(value="type") String var1);

    @GetMapping(value={"api/operation/qrparamer/getbycode"})
    public Response<OperateQrParameter> getOperateQrParameterByCode(@RequestParam(value="code") String var1);

    @GetMapping(value={"api/operation/qrparamer/deleteByCode"})
    public Response deleteOperateQrParameterByCode(@RequestParam(value="code") String var1);

    @GetMapping(value={"api/operation/qrparamer/queryPage"})
    public PageTable<OperateQrParameter> operateQrParameterPageTable(@RequestParam(value="code", required=false) String var1, @RequestParam(value="name", required=false) String var2, @RequestParam(value="type", required=false) String var3, @RequestParam(value="page", defaultValue="1") Integer var4, @RequestParam(value="limit", defaultValue="20") Integer var5);

    @PostMapping(value={"api/operation/qrparamer/saveOrUpdateOperateQrParameter"})
    public Response saveOrUpdateOperateQrParameter(@RequestBody OperateQrParameter var1);

    @GetMapping(value={"api/operation/qr/queryPage"})
    public PageTable<OperateQr> operateQrPageTable(@RequestParam(value="qrCode", required=false) String var1, @RequestParam(value="qrName", required=false) String var2, @RequestParam(value="relationType", required=false) String var3, @RequestParam(value="page", defaultValue="1") Integer var4, @RequestParam(value="limit", defaultValue="20") Integer var5);

    @GetMapping(value={"api/operation/qr/deleteByCode"})
    public Response deleteOperateQrByCode(@RequestParam(value="code") String var1);

    @GetMapping(value={"api/operation/qr/detailByCode"})
    public Response<OperateQr> operateQrDetailByCode(@RequestParam(value="code") String var1);

    @PostMapping(value={"api/operation/qr/saveOperateQr"})
    public Response saveOperateQr(@RequestBody OperateQr var1);

    @PostMapping(value={"/api/operation/qr/saveOperateQrByStoreCode"})
    public Response saveOperateQrByStoreCode(@RequestParam(value="relationCode") String var1, @RequestBody OperateQr var2);

    @GetMapping(value={"api/operation/qr/operateQrListByCode"})
    public Response<List<OperateQr>> operateQrListByCode(@RequestParam(value="qrCodes") String[] var1);

    @PostMapping(value={"/api/operation/iiuv/gainQrCodesByStoreCodes"})
    public Response<Map<String, MerchantStoreQrDto>> gainQrCodesByStoreCodes(@RequestBody List<String> var1);

    @GetMapping(value={"/api/operation/qr/gainQrUrlByStoreCode/{storeCode}"})
    public Response<OperateQr> gainQrUrlByStoreCode(@PathVariable(value="storeCode") String var1);

    @PostMapping(value={"/api/operation/opinion/saveOpinion"})
    public Response saveOpinion(@RequestBody OperateOpinion var1);

    @GetMapping(value={"/api/operation/opinion/findOpinionsByUserCodeAndOpenid"})
    public Response<List<OperateOpinion>> findOpinionsByUserCodeAndOpenid(@RequestParam(value="userCode") String var1, @RequestParam(value="openid", required=false) String var2);

    @GetMapping(value={"/api/operation/opinion/getOpinionByCode"})
    public Response getOpinionByCode(@RequestParam(value="code") String var1);

    @GetMapping(value={"/api/operation/opinion/findOpinionsPageTable"})
    public PageTable<OperateOpinion> findOpinionsPageTable(@RequestParam(value="code", required=false) String var1, @RequestParam(value="userCode", required=false) String var2, @RequestParam(value="openid", required=false) String var3, @RequestParam(value="phone", required=false) String var4, @RequestParam(value="source", required=false) String var5, @RequestParam(value="opinionType", required=false) String var6, @RequestParam(value="createTimeStart", required=false) String var7, @RequestParam(value="createTimeEnd", required=false) String var8, @RequestParam(value="limit", defaultValue="20") int var9, @RequestParam(value="page", defaultValue="1") int var10);

    @GetMapping(value={"/api/operation/opinion/findOpinionsList"})
    public Response<List<OperateOpinion>> findOpinionsList(@RequestParam(value="code", required=false) String var1, @RequestParam(value="userCode", required=false) String var2, @RequestParam(value="openid", required=false) String var3, @RequestParam(value="phone", required=false) String var4, @RequestParam(value="source", required=false) String var5, @RequestParam(value="opinionType", required=false) String var6, @RequestParam(value="createTimeStart", required=false) String var7, @RequestParam(value="createTimeEnd", required=false) String var8);

    @PostMapping(value={"/api/operation/qr/history/saveQrHistory"})
    public Response saveQrHistory(@RequestBody OperateQrScanHistoryDTO var1);

    @GetMapping(value={"/api/operation/qr/history/operateQrHistoryPageTable"})
    public PageTable<OperateQrScanHistory> operateQrHistoryPageTable(@RequestParam(value="qrCode") String var1, @RequestParam(value="userMobile", required=false) String var2, @RequestParam(value="wxOpenid", required=false) String var3, @RequestParam(value="scanTimeStart", required=false) LocalDateTime var4, @RequestParam(value="scanTimeEnd", required=false) LocalDateTime var5, @RequestParam(value="page", defaultValue="1") Integer var6, @RequestParam(value="limit", defaultValue="20") Integer var7);

    @GetMapping(value={"/api/operation/iiuv/getUserAgentIiuvCodeAndQrCode"})
    public Response<OperateIiuvQrDTO> getUserAgentIiuvCodeAndQrCode(@RequestParam(value="code") String var1);
}

