package com.rocogz.syy.order.dto.jms;

import com.rocogz.syy.order.entity.goods.GoodsOrder;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;

/**
 * 碎屏险,手机延保服务 支付结果通知到三星生活助手
 * @author zhangmin
 * @date 2020/11/16
 */
@Setter @Getter
public class NotifyPayResultToSamsungMsg {

    /**
     * 我们积分商城订单号
     */
    private String orderCode;

    /**
     * 会员coupon返回三星传送的值
     */
    private String coupon;

    /**
     * 订单类型,Coupon类型：DI-碎屏险，EW-延保，QY-爱奇艺， GIFT-礼品兑换，ALL-多类型合并支付
     */
    private String type;

    /**
     * 会员ID
     */
    private String memID;

    /**
     * 支付单号,可以传入积分商城的订单号
     */
    private String tranID;


    /**
     * 支付现金(无现金支付为0)
     */
    private String payCash;

    /**
     * 支付积分(无积分支付为0)
     */
    private String payPoint;

    /**
     * 是否分期: Y-分期，N-不分期
     */
    private String payStageYN;

    /**
     * 分期期数，如分期此参数必填
     */
    private String payStageNum;



    public static NotifyPayResultToSamsungMsg valueOf(GoodsOrder goodOrder) {
        NotifyPayResultToSamsungMsg payResultMsg = new NotifyPayResultToSamsungMsg();
        payResultMsg.setCoupon(goodOrder.getSamsungCouponCode());
        payResultMsg.setType(goodOrder.getSamsungCouponType());
        payResultMsg.setOrderCode(goodOrder.getOrderCode());
        payResultMsg.setTranID(goodOrder.getOrderCode());
        payResultMsg.setMemID(goodOrder.getSamsungMemId());
        payResultMsg.setPayCash(String.valueOf(goodOrder.getTotalCash()));
        payResultMsg.setPayPoint(String.valueOf(goodOrder.getTotalCent().intValue()));

        payResultMsg.setPayStageYN("N");

        if(goodOrder.getAlipaySuccessRecord()!=null  &&
                goodOrder.getAlipaySuccessRecord().getAlipayHbFqNum()!=null &&
                goodOrder.getAlipaySuccessRecord().getAlipayHbFqNum()>0) {
            payResultMsg.setPayStageYN("Y");
            payResultMsg.setPayStageNum(String.valueOf(goodOrder.getAlipaySuccessRecord().getAlipayHbFqNum()));
        }
        return payResultMsg;
    }





}
