package com.rocogz.syy.order.entity.orders;

import com.rocogz.syy.common.annotation.UniqueField;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.constant.OrderConstant;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 *  退款记录明细流水
 * </p>
 * @author zhangmin
 * @since 2020-05-28
 */
@Setter @Getter @Accessors(chain = true)
public class OrderRefundRecord extends IdEntity {

    /**
     * 退款明细流水号
     */
    @UniqueField
    private String refundSncode;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 退款单号
     */
    private String refundCode;

    /**
     * 支付单号
     */
    private String payCode;

    /**
     * 对应的支付流水sn号
     */
    private String paySncode;

    /**
     * 本此退款状态 退款中、已退款
     * @see com.rocogz.syy.order.constant.OrderConstant.DictRefundStatus
     */
    private String refundStatus;

    /**
     * 退款金额
     */
    private BigDecimal refundAmt;

    /**
     * 支付方式
     * @see OrderConstant.DictPayWay
     */
    private String payWay;

    /**
     * 支付凭证号
     */
    private String payCredential;

    /**
     * 完成退款时间
     */
    private LocalDateTime finishTime;

    /**
     * 发起退款时间
     */
    private LocalDateTime createTime;


}
