package com.rocogz.syy.order.dto;

import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 取消订单 结果Dto
 * @author zhangmin
 * @date 2020/8/19
 */
@Setter @Getter
public class CancelOrderResultDto {

    /**
     * 订单被取消前的状态
     */
    private String beforeStatus;

    /**
     *被取消的订单编号
     */
    private String orderCode;

    /**
     * 被取消订单 订单创建时间
     */
    private LocalDateTime orderCreateTime;

    //是否虚拟商品
    private Boolean virtual;

    /**
     * 被取消的订单的虚拟商品类型
     */
    private String virtualType;

    /**
     * 如果使用了积分支付，则要退还的积分
     */
    private BigDecimal refundCent;

    /**
     * 扣积分时 使用的支付凭着号,即：扣分接口返回的 apprNo（批准号码)
     */
    private String payCredential;

    /**
     * 被取消订单的商品名称
     */
    private String productName;

    /**
     * 三星会员Id号
     */
    private String samsungMemId;

    /**
     * 三星会员手机号
     */
    private String samsungMobile;

}
