package com.rocogz.syy.order.entity.orders;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 导入三星订单 批次
 * @author zhangmin
 * @date 2020/12/21
 */
@Setter @Getter
@TableName("order_samsung_import")
public class ImportSamsungOrderBatch extends IdEntity {

    //批次号
    private String batchCode;

    //导入开始时间
    private LocalDateTime startTime;

    //导入完成结束时间
    private LocalDateTime endTime;

    //花费时间 秒
    private Integer spendSecond;

    //成功导入的订单数量
    private Integer successNum;

    //导入失败的订单数量
    private Integer failNum;

    //已存在订单数量
    private Integer existNum;

    //导入备注
    private String remark;


    @TableField(exist = false)
    private List<ImportSamsungOrderFailItem> failItemList;
}
