/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.order.constant.OrderStatisOption;
import com.rocogz.syy.order.constant.OtherInfoOption;
import com.rocogz.syy.order.dto.CancelOrderResultDto;
import com.rocogz.syy.order.dto.OrderCashPayDto;
import com.rocogz.syy.order.dto.OrderCentPayDto;
import com.rocogz.syy.order.dto.OrderCountGroupByIMEIDto;
import com.rocogz.syy.order.dto.OrderCountGroupByImeiParamDto;
import com.rocogz.syy.order.dto.OrderCountGroupByStatusDto;
import com.rocogz.syy.order.dto.OrderCountGroupByStatusParamDto;
import com.rocogz.syy.order.dto.OrderSummaryStatistic;
import com.rocogz.syy.order.dto.after.AdminAfterOrderSearchParamDto;
import com.rocogz.syy.order.dto.after.AfterOrderAdminCreateParamDto;
import com.rocogz.syy.order.dto.after.AfterOrderAdminDeliveryLogisticsParamDto;
import com.rocogz.syy.order.dto.after.AfterOrderCreateResponseDto;
import com.rocogz.syy.order.dto.after.AfterOrderLogisticsParamDto;
import com.rocogz.syy.order.dto.after.AfterOrderMallCreateParamDto;
import com.rocogz.syy.order.dto.after.AfterOrderOpeartorBaseParamDto;
import com.rocogz.syy.order.dto.after.AfterOrderRefundParamDto;
import com.rocogz.syy.order.dto.after.AfterOrderRefuseParamDto;
import com.rocogz.syy.order.dto.goods.ConfirmReceiveChangeStatusDto;
import com.rocogz.syy.order.dto.goods.CreateGoodsOrderDto;
import com.rocogz.syy.order.dto.goods.CreateOrderModeEnum;
import com.rocogz.syy.order.dto.goods.DepositResultDto;
import com.rocogz.syy.order.dto.goods.GoodsAdminSearchParamDto;
import com.rocogz.syy.order.dto.goods.GoodsOrderChangeStatusDto;
import com.rocogz.syy.order.dto.goods.PayNotifyResultDto;
import com.rocogz.syy.order.dto.goods.SamsungMemberInfoDto;
import com.rocogz.syy.order.dto.invoice.SelectAndUpdateStatusParam;
import com.rocogz.syy.order.dto.invoice.SubmitInvoiceParamDto;
import com.rocogz.syy.order.dto.jms.NotifyPayResultToSamsungMsg;
import com.rocogz.syy.order.dto.pay.AlipayUnifiedOrderParamDto;
import com.rocogz.syy.order.dto.pay.CashPayRefundParamDto;
import com.rocogz.syy.order.dto.pay.WxPayRepayOrderParamDto;
import com.rocogz.syy.order.dto.pay.WxPayUnifiedOrderParamDto;
import com.rocogz.syy.order.dto.pay.WxPayUnifiedOrderResultDto;
import com.rocogz.syy.order.entity.after.OrderAfter;
import com.rocogz.syy.order.entity.after.OrderAfterLog;
import com.rocogz.syy.order.entity.after.OrderAfterProcessPrompt;
import com.rocogz.syy.order.entity.goods.GoodsOrder;
import com.rocogz.syy.order.entity.invoice.OrderInvoice;
import com.rocogz.syy.order.entity.orders.ImportSamsungOrderBatch;
import com.rocogz.syy.order.entity.orders.ImportSamsungOrderFailItem;
import com.rocogz.syy.order.entity.orders.OrderLog;
import com.rocogz.syy.order.entity.orders.OrderPaymentRecord;
import com.rocogz.syy.order.entity.orders.OrderRefund;
import com.rocogz.syy.order.entity.orders.SaleOrder;
import com.rocogz.syy.order.entity.pay.AlipayPayRecord;
import com.rocogz.syy.order.entity.pay.AlipayRefundRecord;
import com.rocogz.syy.order.entity.pay.OrderPaymentFlow;
import com.rocogz.syy.order.entity.pay.OrderRefundFlow;
import com.rocogz.syy.order.entity.pay.WxPayRecord;
import com.rocogz.syy.order.entity.pay.WxPayRefundRecord;
import com.rocogz.syy.order.entity.qrcode.OrderSamsungQrcode;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

public interface IOrderClientService {
    @PostMapping(value={"/api/order/create"})
    public Response createOrder(@RequestBody SaleOrder var1);

    @GetMapping(value={"/api/order/getOrderMainInfo/{orderCode}"})
    public Response<SaleOrder> getOrderMainInfo(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/getOrderWithOtherInfo/{orderCode}"})
    public Response<SaleOrder> getOrderWithOtherInfo(@PathVariable(value="orderCode") String var1, @RequestParam(value="otherInfoList") List<OtherInfoOption> var2);

    @GetMapping(value={"/api/order/weappSearch"})
    public PageTable<SaleOrder> weappSearch(@RequestParam(value="userCode") String var1, @RequestParam(value="status", required=false) String var2, @RequestParam(value="limit", defaultValue="10") Integer var3, @RequestParam(value="page", defaultValue="1") Integer var4);

    @PostMapping(value={"/api/order/count"})
    public Response<Map<String, OrderSummaryStatistic>> countOrder(@RequestBody List<OrderStatisOption> var1);

    @PostMapping(value={"/api/order/orderCountGroupByStatus"})
    public Response<List<OrderCountGroupByStatusDto>> orderCountGroupByStatus(@RequestBody OrderCountGroupByStatusParamDto var1);

    @PostMapping(value={"/api/order/countGroupByIMEI"})
    public Response<Map<String, OrderCountGroupByIMEIDto>> countOrderGroupByIMEI(@RequestBody OrderCountGroupByImeiParamDto var1);

    @GetMapping(value={"/api/order/delete/{orderCode}"})
    public Response<String> deleteLogical(@PathVariable(value="orderCode") String var1, @RequestParam(value="userCode", required=false) String var2);

    @GetMapping(value={"/api/order/cancelOrder/{orderCode}"})
    public Response<CancelOrderResultDto> cancelOrder(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/updateCancelApplyStatus"})
    public Response updateOrderCancelApplyStatus(@RequestParam(value="orderCode") String var1, @RequestParam(value="newApplyStatus") String var2);

    @GetMapping(value={"/api/order/cancelOrderApproveCallBlack"})
    public Response cancelOrderApproveCallBlack(@RequestParam(value="code") String var1, @RequestParam(value="pass") String var2);

    @GetMapping(value={"/api/order/getUninvoicedOfflineOrder"})
    public PageTable<SaleOrder> getUninvoicedOfflineOrder(@RequestParam(name="unionId") String var1, @RequestParam(value="limit", defaultValue="10") int var2, @RequestParam(value="page", defaultValue="1") int var3);

    @GetMapping(value={"/api/order/orderAfter/{orderCode}"})
    public Response<CancelOrderResultDto> orderAfter(@PathVariable(value="orderCode") String var1);

    @PostMapping(value={"/api/order/updateUserBySamsungMemIdOnRegist"})
    public Response<String> updateUserInfoBySamsungMemIdOnRegist(@RequestBody SamsungMemberInfoDto var1);

    @GetMapping(value={"/api/order/log/{orderCode}"})
    public Response<List<OrderLog>> findLogList(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/scheduleFindExpireOrderCodes"})
    public Response<List<String>> scheduleFindExpireOrderCodes();

    @GetMapping(value={"/api/order/scheduleFindAndAutoCompleteOrder"})
    public Response<List<String>> scheduleFindAndAutoCompleteOrder();

    @PostMapping(value={"/api/order/writeOff/updateOrderStatus"})
    public Response<String> updateStatusWithSaveLog(@RequestBody List<OrderLog> var1);

    @GetMapping(value={"/api/order/wx-pay-record/queryByFlowCodeAndStatus"})
    public Response<WxPayRecord> queryWxPayRecordByFlowCodeAndStatus(@RequestParam(value="flowCode") String var1, @RequestParam(value="wxTradeState", required=false) String var2);

    @PostMapping(value={"/api/order/wx-pay-record/updateById"})
    public Response updateWxPayRecordById(@RequestBody WxPayRecord var1);

    @GetMapping(value={"/api/order/wx-pay-record/queryPage"})
    public PageTable<WxPayRecord> wxPayRecordPageTable(@RequestParam(value="rocoTradeNo", required=false) String var1, @RequestParam(value="wxTransactionId", required=false) String var2, @RequestParam(value="wxUserOpenid", required=false) String var3, @RequestParam(value="rocoResCode", required=false) String var4, @RequestParam(value="rocoTradeType", required=false) String var5, @RequestParam(value="wxTradeState", required=false) String var6, @RequestParam(value="createTimeStart", required=false) String var7, @RequestParam(value="createTimeEnd", required=false) String var8, @RequestParam(value="wxTimeEndStart", required=false) String var9, @RequestParam(value="wxTimeEndEnd", required=false) String var10, @RequestParam(value="limit", defaultValue="20") int var11, @RequestParam(value="page", defaultValue="1") int var12);

    @GetMapping(value={"/api/order/wx-pay-record/wxPayRecordList"})
    public Response<List<WxPayRecord>> wxPayRecordList(@RequestParam(value="rocoTradeNo", required=false) String var1, @RequestParam(value="wxTransactionId", required=false) String var2, @RequestParam(value="wxUserOpenid", required=false) String var3, @RequestParam(value="rocoResCode", required=false) String var4, @RequestParam(value="rocoTradeType", required=false) String var5, @RequestParam(value="wxTradeState", required=false) String var6, @RequestParam(value="createTimeStart", required=false) String var7, @RequestParam(value="createTimeEnd", required=false) String var8, @RequestParam(value="wxTimeEndStart", required=false) String var9, @RequestParam(value="wxTimeEndEnd", required=false) String var10);

    @GetMapping(value={"/api/order/wx-pay-record/getWxPayRecord"})
    public Response<WxPayRecord> getWxPayRecord(@RequestParam(value="rocoTradeNo") String var1, @RequestParam(value="wxTransactionId", required=false) String var2, @RequestParam(value="wxRefundId", required=false) String var3);

    @PostMapping(value={"/api/order/pay/wx/unifiedOrder"})
    public Response<WxPayUnifiedOrderResultDto> unifiedWxPayOrder(@RequestBody WxPayUnifiedOrderParamDto var1);

    @PostMapping(value={"/api/order/pay/wx/repayOrder"})
    public Response<WxPayUnifiedOrderResultDto> repayWxPayOrder(@RequestBody WxPayRepayOrderParamDto var1);

    @GetMapping(value={"/api/order/pay/wx/closeOrder/{outTradeNo}"})
    public Response closeWxPayOrder(@PathVariable(value="outTradeNo") String var1);

    @PostMapping(value={"/api/order/pay/wx/refund"})
    public Response<String> refund(@RequestBody CashPayRefundParamDto var1);

    @GetMapping(value={"/api/order/pay/wx/checkOrderWxPaySuccess"})
    public Response<Boolean> checkOrderWxPaySuccess(@RequestParam(value="appid") String var1, @RequestParam(value="flowCode", required=false) String var2, @RequestParam(value="transactionId", required=false) String var3);

    @GetMapping(value={"/api/order/wx-pay-refund-record/queryByRocoRefundNo"})
    public Response<WxPayRefundRecord> queryWxPayRefundRecordByRocoRefundNo(@RequestParam(value="rocoRefundNo") String var1);

    @GetMapping(value={"/api/order/wx-pay-refund-record/queryByRefundFlowCode"})
    public Response<WxPayRefundRecord> queryWxPayRefundRecordByRefundFlowCode(@RequestParam(value="refundFlowCode") String var1);

    @PostMapping(value={"/api/order/wx-pay-refund-record/updateById"})
    public Response updateWxPayRefundRecordById(@RequestBody WxPayRefundRecord var1);

    @GetMapping(value={"/api/order/wx-pay-refund-record/queryPage"})
    public PageTable<WxPayRefundRecord> wxPayRefundRecordPageTable(@RequestParam(value="rocoTradeNo", required=false) String var1, @RequestParam(value="rocoRefundNo", required=false) String var2, @RequestParam(value="wxRefundId", required=false) String var3, @RequestParam(value="wxTransactionId", required=false) String var4, @RequestParam(value="wxUserOpenid", required=false) String var5, @RequestParam(value="rocoResCode", required=false) String var6, @RequestParam(value="rocoTradeType", required=false) String var7, @RequestParam(value="wxRefundStatus", required=false) String var8, @RequestParam(value="wxRefundRequestSource", required=false) String var9, @RequestParam(value="createTimeStart", required=false) String var10, @RequestParam(value="createTimeEnd", required=false) String var11, @RequestParam(value="wxRefundSuccessTimeStart", required=false) String var12, @RequestParam(value="wxRefundSuccessTimeEnd", required=false) String var13, @RequestParam(value="limit", defaultValue="20") int var14, @RequestParam(value="page", defaultValue="1") int var15);

    @GetMapping(value={"/api/order/wx-pay-refund-record/wxPayRefundRecordList"})
    public Response<List<WxPayRefundRecord>> wxPayRefundRecordList(@RequestParam(value="rocoTradeNo", required=false) String var1, @RequestParam(value="rocoRefundNo", required=false) String var2, @RequestParam(value="wxRefundId", required=false) String var3, @RequestParam(value="wxTransactionId", required=false) String var4, @RequestParam(value="wxUserOpenid", required=false) String var5, @RequestParam(value="rocoResCode", required=false) String var6, @RequestParam(value="rocoTradeType", required=false) String var7, @RequestParam(value="wxRefundStatus", required=false) String var8, @RequestParam(value="wxRefundRequestSource", required=false) String var9, @RequestParam(value="createTimeStart", required=false) String var10, @RequestParam(value="createTimeEnd", required=false) String var11, @RequestParam(value="wxRefundSuccessTimeStart", required=false) String var12, @RequestParam(value="wxRefundSuccessTimeEnd", required=false) String var13);

    @GetMapping(value={"/api/order/goods-order/adminSearch"})
    public PageTable<SaleOrder> adminSearchGoodsOrder(@SpringQueryMap GoodsAdminSearchParamDto var1);

    @PostMapping(value={"/api/order/goods-order/create"})
    public Response<SaleOrder> createGoodsOrder(@RequestBody CreateGoodsOrderDto var1);

    @GetMapping(value={"/api/order/goods-order/getByOrderCode"})
    public Response<GoodsOrder> getGoodsOrderByOrderCode(@RequestParam(value="orderCode") String var1);

    @GetMapping(value={"/api/order/getOrderBySamsungOrderCode"})
    public Response<SaleOrder> getOrderBySamsungOrderCode(@RequestParam(value="samsungOrderCode") String var1, @RequestParam(name="createMode") CreateOrderModeEnum var2);

    @PostMapping(value={"/api/order/goods-order/changeStatus"})
    public Response changeGoodsOrderStatus(@RequestBody GoodsOrderChangeStatusDto var1);

    @PostMapping(value={"/api/order/goods-order/updateExpressInfo"})
    public Response<String> updateGoodOrderExpressInfo(@RequestBody GoodsOrderChangeStatusDto var1);

    @PostMapping(value={"/api/order/goods-order/confirmReceive"})
    public Response confirmReceiveChangeStatus(@RequestBody ConfirmReceiveChangeStatusDto var1);

    @PostMapping(value={"/api/order/goods-order/cashPay"})
    public Response<String> payGoodsOrderByCash(@RequestBody OrderCashPayDto var1);

    @PostMapping(value={"/api/order/goods-order/centPay"})
    public Response<String> payGoodsOrderByCent(@RequestBody OrderCentPayDto var1);

    @PostMapping(value={"/api/order/goods-order/updateNotifySamsungPayResult"})
    public Response updateNotifySamsungPayResult(@RequestBody PayNotifyResultDto var1);

    @PostMapping(value={"/api/order/goods-order/updateDepositResult"})
    public Response updateDepositResult(@RequestBody DepositResultDto var1);

    @GetMapping(value={"/api/order/goods-order/findPendingNotifyGoodOrders"})
    public Response<List<SaleOrder>> findPendingNotifyGoodOrders();

    @PostMapping(value={"/api/order/goods-order/findGoodsOrderByOrderCodes"})
    public Response<List<GoodsOrder>> findGoodsOrderByOrderCodes(@RequestBody List<String> var1);

    @PostMapping(value={"/api/order/goods-order/findOrderCashPayRecordList"})
    public Response<Map<String, OrderPaymentRecord>> findOrderCashPayRecordList(@RequestBody List<String> var1);

    @GetMapping(value={"/api/order/goods-order/manualPush"})
    public Response manualPushGoodOrder(@RequestParam(value="orderCode") String var1);

    @GetMapping(value={"/api/order/goods-order/manualDeposit"})
    public Response manualDeposit(@RequestParam(value="orderItemCode") String var1);

    @GetMapping(value={"/api/order/goods-order/manualPushTest"})
    public Response<NotifyPayResultToSamsungMsg> manualPushGoodOrderTest(@RequestParam(value="orderCode") String var1);

    @GetMapping(value={"/api/order/pay/wx/paymentflow/failure"})
    public Response taskToFailureForOrder();

    @GetMapping(value={"/api/order/after/admin/adminAfterSearch"})
    public PageTable<OrderAfter> adminAfterSearch(@SpringQueryMap AdminAfterOrderSearchParamDto var1);

    @GetMapping(value={"/api/order/after/admin/afterApproveCallBlack"})
    public Response afterApproveCallBlack(@RequestParam(value="pass") String var1, @RequestParam(value="code") String var2, @RequestParam(value="remark", required=false) String var3, @RequestParam(value="updateUser") String var4);

    @PostMapping(value={"/api/order/after/admin/adminCreateAfter"})
    public Response<AfterOrderCreateResponseDto> adminCreateAfter(@RequestBody AfterOrderAdminCreateParamDto var1);

    @PostMapping(value={"/api/order/after/admin/adminAfterRefund"})
    public Response adminAfterRefund(@RequestBody AfterOrderRefundParamDto var1);

    @PostMapping(value={"/api/order/after/admin/adminAfterRefuse"})
    public Response adminAfterRefuse(@RequestBody AfterOrderRefuseParamDto var1);

    @PostMapping(value={"/api/order/after/admin/adminAfterExchangeLogistics"})
    public Response adminAfterExchangeLogistics(@RequestBody AfterOrderAdminDeliveryLogisticsParamDto var1);

    @GetMapping(value={"/api/order/after/admin/getOrderAfterLog"})
    public Response<List<OrderAfterLog>> getOrderAfterLog(@RequestParam(value="afterCode") String var1);

    @GetMapping(value={"/api/order/after/admin/adminAfterDetail"})
    public Response<OrderAfter> adminAfterDetail(@RequestParam(value="afterCode") String var1);

    @GetMapping(value={"/api/order/after/mall/getMainOrderAfter"})
    public Response<OrderAfter> getMainOrderAfter(@RequestParam(value="afterCode") String var1, @RequestParam(value="userCode") String var2);

    @PostMapping(value={"/api/order/after/mall/mallCreateAfter"})
    public Response<AfterOrderCreateResponseDto> mallCreateAfter(@RequestBody AfterOrderMallCreateParamDto var1);

    @PostMapping(value={"/api/order/after/mall/mallAfterReturnLogistics"})
    public Response mallAfterReturnLogistics(@RequestBody AfterOrderLogisticsParamDto var1);

    @PostMapping(value={"/api/order/after/mall/mallAfterLogisticsConfirm"})
    public Response mallAfterLogisticsConfirm(@RequestBody AfterOrderOpeartorBaseParamDto var1);

    @GetMapping(value={"/api/order/after/mall/mallAfterSearch"})
    public PageTable<OrderAfter> mallAfterSearch(@RequestParam(value="userCode") String var1, @RequestParam(value="limit", defaultValue="10") Integer var2, @RequestParam(value="page", defaultValue="1") Integer var3);

    @GetMapping(value={"/api/order/after/mall/mallAfterDetail"})
    public Response<OrderAfter> mallAfterDetail(@RequestParam(value="afterCode") String var1);

    @GetMapping(value={"/api/order/after/mall/mallNoFinishedAfterCount"})
    public Response<Integer> mallNoFinishedAfterCount(@RequestParam(value="userCode") String var1);

    @GetMapping(value={"/api/order/after/admin/adminAfterPromptSearch"})
    public PageTable<OrderAfterProcessPrompt> adminAfterPromptSearch(@RequestParam(value="limit") Integer var1, @RequestParam(value="page") Integer var2);

    @PostMapping(value={"/api/order/after/admin/adminUpdateAfterNodePrompt"})
    public Response adminUpdateAfterNodePrompt(@RequestBody OrderAfterProcessPrompt var1);

    @PostMapping(value={"/api/order/pay/alipay/pay"})
    public Response<String> alipayUnifiedOrder(@Valid @RequestBody AlipayUnifiedOrderParamDto var1);

    @PostMapping(value={"/api/order/pay/alipay/refund"})
    public Response alipayRefundOrder(@Validated @RequestBody CashPayRefundParamDto var1);

    @GetMapping(value={"/api/order/pay/alipay/close/{outTradeNo}"})
    public Response alipayCloseOrder(@PathVariable(value="outTradeNo") String var1);

    @GetMapping(value={"/api/order/alipay-pay-record/getByFlowCode"})
    public Response<AlipayPayRecord> getAlipayPayRecordByFlowCode(@RequestParam(value="flowCode") String var1);

    @PostMapping(value={"/api/order/alipay-pay-record"})
    public Response saveOrUpdateAlipayPayRecord(@RequestBody AlipayPayRecord var1);

    @GetMapping(value={"/api/order/alipay-refund-record/getByFlowCode"})
    public Response<AlipayRefundRecord> getAlipayRefundRecordByFlowCode(@RequestParam(value="flowCode") String var1);

    @PostMapping(value={"/api/order/alipay-refund-record"})
    public Response saveOrUpdateAlipayRefundRecord(@RequestBody AlipayRefundRecord var1);

    @GetMapping(value={"/api/order/order-payment-flow/getByFlowCode"})
    public Response<OrderPaymentFlow> getOrderPaymentFlowByFlowCode(@RequestParam(value="flowCode") String var1);

    @PostMapping(value={"/api/order/order-payment-flow"})
    public Response saveOrUpdateOrderPaymentFlow(@RequestBody OrderPaymentFlow var1);

    @GetMapping(value={"/api/order/order-refund-flow/getByFlowCode"})
    public Response<OrderRefundFlow> getOrderRefundFlowByFlowCode(@RequestParam(value="flowCode") String var1);

    @PostMapping(value={"/api/order/order-refund-flow"})
    public Response saveOrUpdateOrderRefundFlow(@RequestBody OrderRefundFlow var1);

    @PostMapping(value={"/api/order/qrcode/saveQrcode"})
    public Response saveQrcode(@RequestBody OrderSamsungQrcode var1);

    @GetMapping(value={"/api/order/qrcode/query/{sceneNo}"})
    public Response<OrderSamsungQrcode> getQrcode(@PathVariable(value="sceneNo") String var1);

    @RequestMapping(value={"/api/order/orderRefundByOrderCode"})
    public Response<OrderRefund> getOrderRefundByOrderCode(@RequestParam(value="orderCode") String var1);

    @GetMapping(value={"/api/order/after/admin/getBaseAfterInfoByAfterCode"})
    public Response<OrderAfter> getBaseAfterInfoByAfterCode(@RequestParam(value="afterCode") String var1);

    @PostMapping(value={"/api/order/goods-order/sendVirtualGoodDeliverJms"})
    public Response sendVirtualGoodDeliverJms(@RequestBody List<String> var1);

    @PostMapping(value={"/api/order/importSamsung/report/save"})
    public Response saveSamsungOrderImportReport(@RequestBody ImportSamsungOrderBatch var1);

    @PostMapping(value={"/api/order/importSamsung/report/update"})
    public Response updateSamsungOrderImportReport(@RequestBody ImportSamsungOrderBatch var1);

    @GetMapping(value={"/api/order/importSamsung/report/list"})
    public Response<List<ImportSamsungOrderBatch>> findImportReportList();

    @GetMapping(value={"/api/order/importSamsung/report/{batchCode}"})
    public Response<ImportSamsungOrderBatch> getReportByBatchCode(@PathVariable(value="batchCode") String var1, @RequestParam(value="status", defaultValue="0") Integer var2, @RequestParam(value="isLoadItem", defaultValue="true") Boolean var3);

    @PostMapping(value={"/api/order/importSamsung/report/saveFailItemList"})
    public Response saveSamsungOrderImportFailItemList(@RequestBody List<ImportSamsungOrderFailItem> var1);

    @PostMapping(value={"/api/order/importSamsung/report/batchUpdateItemResult"})
    public Response batchUpdateSamsungOrderImportResultList(@RequestBody List<ImportSamsungOrderFailItem> var1);

    @GetMapping(value={"/api/order/invoice"})
    public PageTable<OrderInvoice> searchInvoice(@RequestParam(name="applyCode", required=false) String var1, @RequestParam(name="invoiceTitle", required=false) String var2, @RequestParam(name="invoiceNo", required=false) String var3, @RequestParam(name="startTime", required=false) String var4, @RequestParam(name="endTime", required=false) String var5, @RequestParam(name="mobile", required=false) String var6, @RequestParam(name="email", required=false) String var7, @RequestParam(name="invoiceType", required=false) String var8, @RequestParam(name="titleType", required=false) String var9, @RequestParam(name="status", required=false) String var10, @RequestParam(name="limit", defaultValue="20") int var11, @RequestParam(name="page", defaultValue="1") int var12);

    @GetMapping(value={"/api/order/invoice/searchInvoiceByUnionId"})
    public PageTable<OrderInvoice> searchInvoiceByUnionId(@RequestParam(name="unionId") String var1, @RequestParam(name="limit", defaultValue="20") int var2, @RequestParam(name="page", defaultValue="1") int var3);

    @GetMapping(value={"/api/order/invoice/getInvoiceByApplyCode"})
    public Response<OrderInvoice> getInvoiceDetailByApplyCode(@RequestParam(name="applyCode") String var1);

    @PostMapping(value={"/api/order/invoice/submitInvoice"})
    public Response<String> submitInvoice(@RequestBody SubmitInvoiceParamDto var1);

    @PostMapping(value={"/api/order/invoice/batchSelectAndUpdateStatus"})
    public Response<List<OrderInvoice>> batchSelectAndUpdateInvoiceStatus(@RequestBody SelectAndUpdateStatusParam var1);

    @PostMapping(value={"/api/order/invoice/singleSelectAndUpdateStatus"})
    public Response<OrderInvoice> singleSelectAndUpdateInvoiceStatus(@RequestBody SelectAndUpdateStatusParam var1);

    @PostMapping(value={"/api/order/invoice/batchUpdateStatus"})
    public Response batchUpdateInvoiceStatus(@RequestBody SelectAndUpdateStatusParam var1);
}

