package com.rocogz.syy.order.dto.goods;

import com.rocogz.syy.order.dto.invoice.SubmitInvoiceParamDto;
import com.rocogz.syy.order.entity.goods.GoodsOrderDeliveryAddress;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 创建订单,子订单Dto
 */
@Setter @Getter
@Accessors(chain = true)
public class GoodOrderItemDto extends SamsungMemberInfoDto {

    //三星生活助手订单的 coupon信息
    private String samsungCouponCode;

    private String samsungCouponType;

    /**
     *  线上碎屏险 申领人名字
     */
    private String samsungApplierName;

    /**
     *  线上碎屏险 申领日期
     */
    private LocalDate samsungApplyDate;
    /**
     * 管家专项服务商品订单,手机imei号
     */
    private String imei;

    /**
     * 管家专项服务商品订单,手机型号
     */
    private String mobileModel;

    /**
     * 商品编号
     */
    private String goodCode;

    /**
     * erp商品编号
     */
    private String erpCode;

    /**
     * 商品名称
     */
    @NotEmpty
    private String goodName;

    /**
     * sku编号
     */
    @NotEmpty
    private String skuCode;

    /**
     * 商品展示图片url
     */
    private String pictureUrl;

    /**
     * 白色,xl
     */
    private String attrValues;

    /**
     * 是否虚拟商品
     */
    @NotNull
    private Boolean virtual;

    /**
     * 虚拟商品类型：卡券(CARD)、 充值(DEPOSIT)、 碎屏险(SCREEN_CRASH_INSURANCE)、 电池券/换壳券(COUPON)
     */
    private String virtualType;


    /**
     * 该商品是否支持花呗分期付款,订单详情发起再次支付时使用
     */
    private Boolean pcreditSupported;

    /**
     * 是否管家服务
     */
    private Boolean butlerService;

    /**
     * 购买管家服务商品时,如果使用了特权，则设置使用的特权Id
     */
    private Integer superPermissionId;

    /**
     * 是否三星专区商品
     */
    private Boolean samsungPrefecture;


    /**
     * 商品供应商编号
     */
    private String supplierCode;

    /**
     * 商品供应商名称
     */
    private String supplierName;


    /**
     * 商品支付方式: 纯积分(CENT)、现金抵扣积分(CASH_DEDUCTION)、固定积分+固定现金(CENT_WITH_CASH)
     */
    private String goodPayWay;


    /**
     * 积分价
     * （1）"纯积分"支付方式：纯积分
     * （2）"现金抵扣兑换"支付方式：总积分
     * （3）"固定积分+固定现金"支付方式： 固定积分
     */
    private BigDecimal cent;

    /**
     * "现金抵扣兑换"支付方式下：需支付的最少积分
     */
    private BigDecimal minCent;

    /**
     *
     * "固定积分+固定现金" 支付方式下：固定现金价
     */
    private BigDecimal cash;

    /**
     * 运营服务费率: 4表示 4%
     */
    private BigDecimal operationServiceRate;

    /**
     * 结算价
     */
    private BigDecimal settlementPrice;

    /**
     * 商品购买数量
     */
    private Integer quantity;

    /**
     * 充值手机号：如果购买的是 充值虚拟商品(话费,流量)
     */
    private String depositMobile;

    /**
     * 对接充值方：充值业务类型
     */
    private String chargeBizType;

    /**
     * 对接充值方：充值商品Id
     */
    private String  chargeProductId;


    /**
     * 小计:需支付订单现金金额[现金部分]
     */
    private BigDecimal totalCash = BigDecimal.ZERO;

    /**
     * 小计：需支付订单积分 [积分部分]
     */
    private BigDecimal totalCent = BigDecimal.ZERO;


    /**
     * 备注
     */
    private String remark;

}
