package com.rocogz.syy.order.constant;

import com.google.common.collect.Lists;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

import com.rocogz.syy.order.constant.OrderConstant.DictOrderStatus;

/**
 * 商户端 订单核销量统计 选项
 *
 * @author zhangmin
 * @date 2020/5/21
 */
@Getter
@Setter
public class OrderStatisOption {

    //统计时间方式
    private StatisTimeRangeEnum timeRange;

    //商品编号
    private String goodCode;

    //按照会员编号统计
    private String userCode;

    //按照充值手机号统计
    private String depositMobile;

    /**
     * 统计的订单状态：空表示不限制订单状态
     */
    private List<String> statusList;


    //自定义时间统计方式：传入到时间
    private String startTime;

    private String endTime;

    public OrderStatisOption() {
    }

    /**
     * 默认统计：不限制订单类型,订单状态是已核销的
     *
     * @param timeRange
     */
    public OrderStatisOption(StatisTimeRangeEnum timeRange) {
        //默认统计的订单状态是已完成的
        this(timeRange, null, null, null, Lists.newArrayList(DictOrderStatus.FINISHED));
    }


    public OrderStatisOption(StatisTimeRangeEnum timeRange, String userCode, String depositMobile, String goodCode) {
        //统计不包含取消状态的
        this(timeRange, userCode, depositMobile, goodCode, Lists.newArrayList(DictOrderStatus.PENDING_PAY, DictOrderStatus.PENDING_DELIVERY, DictOrderStatus.DELIVERED, DictOrderStatus.FINISHED));
    }


    public OrderStatisOption(StatisTimeRangeEnum timeRange, String userCode, String depositMobile, String goodCode, List<String> statusList) {
        this.timeRange = timeRange;

        if (!StatisTimeRangeEnum.CUSTOM.equals(timeRange)) {
            this.startTime = timeRange.getStartTime();
            this.endTime = timeRange.getEndTime();
        }

        this.userCode = userCode;
        this.depositMobile = depositMobile;
        this.goodCode = goodCode;

        this.statusList = statusList;
    }


    /**
     * 自定义时间范围统计
     *
     * @param startTime
     * @param endTime
     */
    public OrderStatisOption(String startTime, String endTime) {
        this.timeRange = StatisTimeRangeEnum.CUSTOM;
        this.startTime = startTime;
        this.endTime = endTime;
    }
}
