/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.entity.orders;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.entity.goods.GoodsOrder;
import com.rocogz.syy.order.entity.orders.SaleOrder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

@TableName(value="order_push_discount_coupon_order")
public class PushDiscountCouponOrder
extends IdEntity {
    public static final String CANCELED_STATUS = "CNCL";
    public static final String SOLD_STATUS = "SOLD";
    public static final String SEPERATOR = "|";
    private LocalDate dataDate;
    private Integer orderId;
    private String orderCode;
    private String orderStatus;
    private String orderDate;
    private String orderTime;
    private String goodName;
    private String samsungItemCode;
    private String totalMoney;
    private String discountRedeemCode;
    private String cutDownMoney;
    private String totalCent;
    private String centOrderCode;
    private String payCashMoney;
    private String samsungMemCode;
    private String discountPushStatus;

    public static PushDiscountCouponOrder valueOf(GoodsOrder goodOrder) {
        BigDecimal HUNDRED = new BigDecimal(100);
        SaleOrder order = goodOrder.getSaleOrder();
        PushDiscountCouponOrder pushOrderDto = new PushDiscountCouponOrder();
        pushOrderDto.setOrderId(order.getId());
        pushOrderDto.setDiscountPushStatus(order.getDiscountPushStatus());
        pushOrderDto.setOrderCode(goodOrder.getOrderCode());
        if ("CANCELED".equalsIgnoreCase(order.getOrderStatus())) {
            pushOrderDto.setOrderStatus(CANCELED_STATUS);
        } else {
            pushOrderDto.setOrderStatus(SOLD_STATUS);
        }
        pushOrderDto.setOrderDate(order.getCreateTime().toLocalDate().toString());
        DateTimeFormatter df = DateTimeFormatter.ofPattern("HH:mm:ss");
        pushOrderDto.setOrderTime(df.format(order.getCreateTime().toLocalTime()));
        pushOrderDto.setGoodName(goodOrder.getGoodName());
        String samItemCode = StringUtils.isNotBlank((CharSequence)goodOrder.getSamsungItemCode()) ? goodOrder.getSamsungItemCode() : goodOrder.getGoodCode();
        pushOrderDto.setSamsungItemCode(samItemCode);
        BigDecimal totalMoney = goodOrder.getCash().multiply(HUNDRED).add(goodOrder.getCent()).multiply(new BigDecimal(goodOrder.getQuantity()));
        BigDecimal cutdownMoney = order.getCutDownCash().multiply(HUNDRED).add(order.getCutDownCent());
        BigDecimal payCashMoney = order.getTotalCash().multiply(HUNDRED);
        pushOrderDto.setTotalMoney(String.valueOf(totalMoney));
        pushOrderDto.setDiscountRedeemCode(order.getDiscountRedeemCode());
        pushOrderDto.setCutDownMoney(String.valueOf(cutdownMoney));
        pushOrderDto.setTotalCent(String.valueOf(order.getTotalCent()));
        pushOrderDto.setCentOrderCode(goodOrder.getOrderCode());
        pushOrderDto.setPayCashMoney(String.valueOf(payCashMoney));
        pushOrderDto.setSamsungMemCode(goodOrder.getSamsungMemId());
        return pushOrderDto;
    }

    public String toString() {
        StringBuffer orderInfoBuf = new StringBuffer();
        orderInfoBuf.append(this.orderCode).append(SEPERATOR).append(this.orderStatus).append(SEPERATOR).append(this.orderDate).append(SEPERATOR).append(this.orderTime).append(SEPERATOR).append(this.goodName).append(SEPERATOR).append(this.samsungItemCode).append(SEPERATOR).append(this.totalMoney).append(SEPERATOR).append(this.discountRedeemCode).append(SEPERATOR).append(this.cutDownMoney).append(SEPERATOR).append(this.totalCent).append(SEPERATOR).append(this.centOrderCode).append(SEPERATOR).append(this.payCashMoney).append(SEPERATOR).append(this.samsungMemCode);
        return orderInfoBuf.toString();
    }

    public PushDiscountCouponOrder setDataDate(LocalDate dataDate) {
        this.dataDate = dataDate;
        return this;
    }

    public PushDiscountCouponOrder setOrderId(Integer orderId) {
        this.orderId = orderId;
        return this;
    }

    public PushDiscountCouponOrder setOrderCode(String orderCode) {
        this.orderCode = orderCode;
        return this;
    }

    public PushDiscountCouponOrder setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
        return this;
    }

    public PushDiscountCouponOrder setOrderDate(String orderDate) {
        this.orderDate = orderDate;
        return this;
    }

    public PushDiscountCouponOrder setOrderTime(String orderTime) {
        this.orderTime = orderTime;
        return this;
    }

    public PushDiscountCouponOrder setGoodName(String goodName) {
        this.goodName = goodName;
        return this;
    }

    public PushDiscountCouponOrder setSamsungItemCode(String samsungItemCode) {
        this.samsungItemCode = samsungItemCode;
        return this;
    }

    public PushDiscountCouponOrder setTotalMoney(String totalMoney) {
        this.totalMoney = totalMoney;
        return this;
    }

    public PushDiscountCouponOrder setDiscountRedeemCode(String discountRedeemCode) {
        this.discountRedeemCode = discountRedeemCode;
        return this;
    }

    public PushDiscountCouponOrder setCutDownMoney(String cutDownMoney) {
        this.cutDownMoney = cutDownMoney;
        return this;
    }

    public PushDiscountCouponOrder setTotalCent(String totalCent) {
        this.totalCent = totalCent;
        return this;
    }

    public PushDiscountCouponOrder setCentOrderCode(String centOrderCode) {
        this.centOrderCode = centOrderCode;
        return this;
    }

    public PushDiscountCouponOrder setPayCashMoney(String payCashMoney) {
        this.payCashMoney = payCashMoney;
        return this;
    }

    public PushDiscountCouponOrder setSamsungMemCode(String samsungMemCode) {
        this.samsungMemCode = samsungMemCode;
        return this;
    }

    public PushDiscountCouponOrder setDiscountPushStatus(String discountPushStatus) {
        this.discountPushStatus = discountPushStatus;
        return this;
    }

    public LocalDate getDataDate() {
        return this.dataDate;
    }

    public Integer getOrderId() {
        return this.orderId;
    }

    public String getOrderCode() {
        return this.orderCode;
    }

    public String getOrderStatus() {
        return this.orderStatus;
    }

    public String getOrderDate() {
        return this.orderDate;
    }

    public String getOrderTime() {
        return this.orderTime;
    }

    public String getGoodName() {
        return this.goodName;
    }

    public String getSamsungItemCode() {
        return this.samsungItemCode;
    }

    public String getTotalMoney() {
        return this.totalMoney;
    }

    public String getDiscountRedeemCode() {
        return this.discountRedeemCode;
    }

    public String getCutDownMoney() {
        return this.cutDownMoney;
    }

    public String getTotalCent() {
        return this.totalCent;
    }

    public String getCentOrderCode() {
        return this.centOrderCode;
    }

    public String getPayCashMoney() {
        return this.payCashMoney;
    }

    public String getSamsungMemCode() {
        return this.samsungMemCode;
    }

    public String getDiscountPushStatus() {
        return this.discountPushStatus;
    }
}

