package com.rocogz.syy.order.dto;

import lombok.Getter;
import lombok.Setter;

import java.time.LocalDateTime;

/**
 * 订单核销-> 用户券信息
 * @author zhangmin
 * @date 2020/4/28
 */
@Setter @Getter
public class OrderUserCouponDto {

    //优惠券信息
    private OrderCouponDto couponDto;

    /**
     * 用户券编码
     */
    private String userCouponCode;

    /**
     * 用户券状态：未生效、未使用、已使用、已过期、已冻结、已作废
     */
    private String status;

    /**
     * 生效日期
     */
    private LocalDateTime effectiveDate;

    /**
     * 订单失效日期
     */
    private LocalDateTime orderInvalidDate;

    /**
     * 用户券总共能用次数
     */
    private Integer totalQuantity;

    /**
     * 已用次数
     */
    private Integer useQuantity;

    /**
     * 可用次数
     */
    private Integer availableQuantity;

    /**
     * 会员编号
     */
    private String userCode;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 微信openid
     */
    private String openId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 车牌号
     */
    private String licenseNo;

}
