package com.rocogz.syy.order.entity.orders;

import com.rocogz.syy.common.annotation.UniqueField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * @author zhangmin
 * @date 2020/5/27
 */
@Setter @Getter  @Accessors(chain = true)
public abstract class BaseUserInfo extends IdEntity {


    /**
     * 订单编号
     */
    @UniqueField
    private String orderCode;

    /**
     * 会员编号，即车主编号
     */
    private String userCode;

    /**
     * 会员openid
     */
    private String userOpenid;

    /**
     * 会员手机号
     */
    private String userMobile;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


}
