package com.rocogz.syy.order.entity.orders;

import com.baomidou.mybatisplus.annotation.TableField;
import com.google.common.collect.Maps;
import com.rocogz.syy.common.annotation.UniqueField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * <p>
 * 订单支付记录明细
 * </p>
 * @author zhangmin
 * @since 2020-05-28
 */
@Setter @Getter @Accessors(chain = true)
public class OrderPaymentRecord extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 支付流水号
     */
    @UniqueField
    private String paySncode;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 支付单号
     */
    private String payCode;


    /**
     * 支付方式：电子券支付、服务券兑换、电子加油券支付
     * @see com.rocogz.syy.order.constant.OrderConstant.DictPayWay
     */
    private String payWay;

    /**
     * 支付凭证号：如：用户券编号、加油电子券编号
     */
    private String payCredential;

    /**
     * 用户券核销码
     */
    @TableField("writeoff_code")
    private String writeOffCode;

    /**
     * 支付额度：如现金多少，积分多少
     */
    private BigDecimal payAmt;

    /**
     * 剩余未支付金额（支付成功时更新）
     */
    private BigDecimal unpayAmt;

    /**
     * 此次支付状态: 未支付、支付完成
     * @see  com.rocogz.syy.order.constant.OrderConstant.DictPayStatus
     */
    private String payStatus;

    /**
     * 扩展属性信息
     */
    @TableField("ext_attrs")
    private String extAttrsJson;

    /**
     * 成功完成支付时间
     */
    private LocalDateTime finishTime;

    /**
     * 发起支付时间
     */
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;

    private transient Map<String,Object> extAttrData;

    // 以下是方便页面显示
    private transient String payStatusLabel;
    private transient String payWayLabel;

    public void putExtAttr(String key,Object value) {
        if(StringUtils.isNotEmpty(key)) {
            if(extAttrData == null) {
                extAttrData = Maps.newHashMap();
            }
            extAttrData.put(key,value);
        }
    }

}
