package com.rocogz.syy.order.constant;

import com.rocogz.util.DateUtil;
import lombok.Getter;

import java.time.LocalDate;

/**
 * 统计时间范围方式
 *
 * @author zhangmin
 * @date 2020/5/26
 */
@Getter
public enum StatisTimeRangeEnum {

    TODAY("今天") {
        @Override
        public String getStartTime() {
            String today = DateUtil.format(LocalDate.now(), DateUtil.YYYY_MM_DD);
            return today + DateUtil.START_TIME;
        }

        @Override
        public String getEndTime() {
            String today = DateUtil.format(LocalDate.now(), DateUtil.YYYY_MM_DD);
            return today + DateUtil.END_TIME;
        }
    },


    THIS_WEEK("本周") {
        @Override
        public String getStartTime() {
            String firstDayThisWeek = DateUtil.getFirstDayOfWeek(new java.util.Date());
            String dateTime = firstDayThisWeek + DateUtil.START_TIME;
            return  dateTime;
        }

        @Override
        public String getEndTime() {
            String lastDayThisWeek = DateUtil.getLastDayOfWeek(new java.util.Date());
            String dateTime = lastDayThisWeek + DateUtil.END_TIME;
            return dateTime;
        }
    },

    THIS_MONTH("本月") {
        @Override
        public String getStartTime() {
            LocalDate now = LocalDate.now();
            String month = now.getMonthValue()<10? "0"+now.getMonthValue() : String.valueOf(now.getMonthValue());
            String yearMonth = now.getYear() + "-" + month;
            String firstDayThisMonth = DateUtil.getFirstDayOfMonth(yearMonth);
            String dateTime = firstDayThisMonth + DateUtil.START_TIME;
            return dateTime;
        }

        @Override
        public String getEndTime() {
            LocalDate now =  LocalDate.now();
            String month = now.getMonthValue()<10? "0"+now.getMonthValue() : String.valueOf(now.getMonthValue());
            String yearMonth = now.getYear() + "-" + month;
            String lastDayThisMonth = DateUtil.getLastDayOfMonth(yearMonth);
            String dateTime = lastDayThisMonth + DateUtil.END_TIME;
            return dateTime;
        }
    },

    ALL("全部"),

    CUSTOM("自定义时间范围");

    private String label;

    StatisTimeRangeEnum(String label) {
        this.label = label;
    }


    public String getStartTime() {
        return null;
    }

    public String getEndTime() {
        return null;
    }

}
