package com.rocogz.syy.order.entity.trace;

import com.rocogz.syy.order.constant.trace.BussiSystemEnum;
import com.rocogz.syy.order.constant.trace.BussiTypeEnum;
import com.rocogz.syy.order.constant.trace.CallApiEnum;
import com.rocogz.syy.order.dto.trace.TraceDto;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.beans.BeanUtils;

/**
 * <p>
 * 调用内部系统 feign接口 错误跟踪
 * </p>
 * @author zhangmin
 * @since 2020-05-28
 */
@Setter @Getter
@Accessors(chain = true)
public class OrderErrorTrace extends BaseTrace {

    /**
     * 调用的目标系统
     * @see
     */
    private BussiSystemEnum targetSystem;

    /**
     * 业务类型：例如 优惠券核销
     */
    private BussiTypeEnum bussType;

    /**
     * 调用的远程 action 枚举
     */
    private CallApiEnum callApi;

    /**
     * 出错的类名
     */
    private String errorClassName;

    /**
     * 出错代码行号
     */
    private Integer errorLine;

    /**
     * 出错的方法签名
     */
    private String errorMethod;


    /**
     * 错误堆栈信息
     */
    private String stackTrace;


    public static OrderErrorTrace valueOf(TraceDto traceDto) {
        OrderErrorTrace errorTrace = new OrderErrorTrace();
        BeanUtils.copyProperties(traceDto,errorTrace);
        return errorTrace;
    }

}
