package com.rocogz.syy.order.util;

import lombok.extern.slf4j.Slf4j;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

/**
 * <dl>
 * <dd>Description: IpAddressUtil</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/6/29 10:51</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Slf4j
public class IpAddressUtil {
    private IpAddressUtil(){}

    /**
     * 启动时获取到的本机ip地址.
     */
    public static String START_IP_ADDRESS = "127.0.0.1";

    static {
        START_IP_ADDRESS = getRealIpNow();
    }

    /**
     *
     * @return
     */
    public static String getRealIpNow() {
        // 本地IP，如果没有配置外网IP则返回它
        String localIp = null;
        // 外网IP
        String netIp = null;

        Enumeration<NetworkInterface> netInterfaces;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
        } catch (SocketException e) {
            log.error("获取ip地址出现异常", e);
            return START_IP_ADDRESS;
        }
        InetAddress ip;
        // 是否找到外网IP
        boolean isFind = false;
        while (netInterfaces.hasMoreElements() && !isFind) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> address = ni.getInetAddresses();
            while (address.hasMoreElements()) {
                ip = address.nextElement();
                if (!ip.isSiteLocalAddress() && !ip.isLoopbackAddress() && !ip.getHostAddress().contains(":")) {
                    // 外网IP
                    netIp = ip.getHostAddress();
                    isFind = true;
                    break;
                } else if (ip.isSiteLocalAddress() && !ip.isLoopbackAddress()
                        && !ip.getHostAddress().contains(":")) {
                    // 内网IP
                    localIp = ip.getHostAddress();
                }
            }
        }

        if (netIp != null && !"".equals(netIp)) {
            return netIp;
        } else {
            return localIp;
        }
    }
}
