/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.constant;

import com.rocogz.util.DateUtil;
import java.time.LocalDate;
import java.util.Date;

public enum StatisTimeRangeEnum {
    TODAY("\u4eca\u5929"){

        @Override
        public String getStartTime() {
            String today = DateUtil.format((LocalDate)LocalDate.now(), (String)"yyyy-MM-dd");
            return today + " 00:00:00";
        }

        @Override
        public String getEndTime() {
            String today = DateUtil.format((LocalDate)LocalDate.now(), (String)"yyyy-MM-dd");
            return today + " 23:59:59";
        }
    }
    ,
    THIS_WEEK("\u672c\u5468"){

        @Override
        public String getStartTime() {
            String firstDayThisWeek = DateUtil.getFirstDayOfWeek((Date)new Date());
            String dateTime = firstDayThisWeek + " 00:00:00";
            return dateTime;
        }

        @Override
        public String getEndTime() {
            String lastDayThisWeek = DateUtil.getLastDayOfWeek((Date)new Date());
            String dateTime = lastDayThisWeek + " 23:59:59";
            return dateTime;
        }
    }
    ,
    THIS_MONTH("\u672c\u6708"){

        @Override
        public String getStartTime() {
            LocalDate now = LocalDate.now();
            String month = now.getMonthValue() < 10 ? "0" + now.getMonthValue() : String.valueOf(now.getMonthValue());
            String yearMonth = now.getYear() + "-" + month;
            String firstDayThisMonth = DateUtil.getFirstDayOfMonth((String)yearMonth);
            String dateTime = firstDayThisMonth + " 00:00:00";
            return dateTime;
        }

        @Override
        public String getEndTime() {
            LocalDate now = LocalDate.now();
            String month = now.getMonthValue() < 10 ? "0" + now.getMonthValue() : String.valueOf(now.getMonthValue());
            String yearMonth = now.getYear() + "-" + month;
            String lastDayThisMonth = DateUtil.getLastDayOfMonth((String)yearMonth);
            String dateTime = lastDayThisMonth + " 23:59:59";
            return dateTime;
        }
    }
    ,
    ALL("\u5168\u90e8"),
    CUSTOM("\u81ea\u5b9a\u4e49\u65f6\u95f4\u8303\u56f4");

    private String label;

    private StatisTimeRangeEnum(String label) {
        this.label = label;
    }

    public String getStartTime() {
        return null;
    }

    public String getEndTime() {
        return null;
    }

    public String getLabel() {
        return this.label;
    }
}

