package com.rocogz.syy.user.entity.info;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户中心-用户信息
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-11-04
 */
@Data
@TableName("user_basic_info")
public class UserBasicInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 用户编号
     */
    private String code;

    /**
     * 微信unionid
     */
    private String wxUnionid;

    /**
     * 微信绑定手机号码
     */
    private String wxMobile;

    /**
     * 微信openid
     */
    private String wxOpenid;

    /**
     * 微信昵称
     */
    private String wxNickName;

    /**
     * 微信头像url
     */
    private String wxAvatarUrl;

    /**
     * 微信用户性别
     */
    private Integer wxGender;

    /**
     * 注册渠道, WX_MINI:微信小程序; WX_MP:微信公众号; WAP:手机WAP; WEB:PC网页; APP:手机APP
     */
    private String registerChannel;

    /**
     * 注册日期
     */
    private LocalDate registerDate;

    /**
     * 注册时间
     */
    private LocalDateTime registerTime;

    /**
     * 注册ip
     */
    private String registerIp;

    /**
     * 状态
     */
    private String status;

    /**
     * 三星账户-会员号
     */
    private String samsungMemId;

    /**
     * 三星账号绑定手机号码
     */
    @TableField(exist = false)
    private String samsungAccountBindMobile;

    /**
     * 三星账号-姓名
     */
    @TableField(exist = false)
    private String samsungMemFullName;

}
