package com.rocogz.syy.user.constant;

/**
 * <dl>
 * <dd>Description: 用户中心服务常量类</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/4/22 17:03</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
public final class UserConstant {
    private UserConstant(){}

    /**
     * 字典值
     */
    public class DictData {
        private DictData(){}
        public static final String CAR_OWNER_USER_STATUS_NORMAL_CODE = "NORMAL";
        /** 通用的是 */
        public static final String COMMON_YES = "Y";
        /** 通用的否 */
        public static final String COMMON_NO = "N";
    }


    /**
     * 用户注册渠道
     */
    public static class UserRegisterChannel {
        private UserRegisterChannel() {
        }
        public static final String TYPE_CODE = "USER_REGISTER_CHANNEL";
        /**
         * 微信小程序
         */
        public static final String WX_MINI = "WX_MINI";
        /**
         * 微信公众号
         */
        public static final String WX_MP = "WX_MP";
        /**
         * 手机网页
         */
        public static final String WAP = "WAP";
        /**
         * PC网页
         */
        public static final String WEB = "WEB";
        /**
         * 手机APP
         */
        public static final String APP = "APP";
    }

}
