package com.rocogz.syy.user.entity.delivery.address;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 用户中心-用户收货地址
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-08-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("user_delivery_address")
public class UserDeliveryAddress extends IdEntity {

    private static final long serialVersionUID = -4085456531503271608L;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 收货人
     */
    private String addressee;

    /**
     * 地址-省份
     */
    private String addressProvince;

    /**
     * 地址-城市
     */
    private String addressCity;

    /**
     * 地址-区/县
     */
    private String addressDistrict;

    /**
     * 地址-街道门牌号等信息
     */
    private String addressStreet;

    /**
     * 完整地址
     */
    private String fullAddress;

    /**
     * 标签名称
     */
    private String labelName;

    /**
     * 是否是默认地址
     */
    private Boolean defaultAddress;

    /**
     * 是否被逻辑删除
     */
    private Boolean deleted;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


}
