package com.rocogz.syy.user.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;

import java.time.LocalDateTime;

/**
 * <p>
 * 用户中心-用户登录日志
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-04-17
 */
@TableName("user_login_log")
public class UserLoginLog extends IdEntity {

    private static final long serialVersionUID = 3825359971279085657L;
    /**
     * 用户编号
     */
    private String userCode;

    /**
     * openid
     */
    private String wxOpenid;

    /**
     * 登录时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    private LocalDateTime loginTime;

    /**
     * 登录ip
     */
    private String loginIp;

    /**
     * 登录地点经纬度
     */
    private String loginLatlng;

    /**
     * 登录省份
     */
    private String loginProvince;

    /**
     * 登录城市
     */
    private String loginCity;

    /**
     * 登录区/镇
     */
    private String loginDistrict;

    /**
     * 登录地点详细地址
     */
    private String loginAddress;


    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getWxOpenid() {
        return wxOpenid;
    }

    public void setWxOpenid(String wxOpenid) {
        this.wxOpenid = wxOpenid;
    }

    public LocalDateTime getLoginTime() {
        return loginTime;
    }

    public void setLoginTime(LocalDateTime loginTime) {
        this.loginTime = loginTime;
    }

    public String getLoginIp() {
        return loginIp;
    }

    public void setLoginIp(String loginIp) {
        this.loginIp = loginIp;
    }

    public String getLoginLatlng() {
        return loginLatlng;
    }

    public void setLoginLatlng(String loginLatlng) {
        this.loginLatlng = loginLatlng;
    }

    public String getLoginProvince() {
        return loginProvince;
    }

    public void setLoginProvince(String loginProvince) {
        this.loginProvince = loginProvince;
    }

    public String getLoginCity() {
        return loginCity;
    }

    public void setLoginCity(String loginCity) {
        this.loginCity = loginCity;
    }

    public String getLoginDistrict() {
        return loginDistrict;
    }

    public void setLoginDistrict(String loginDistrict) {
        this.loginDistrict = loginDistrict;
    }

    public String getLoginAddress() {
        return loginAddress;
    }

    public void setLoginAddress(String loginAddress) {
        this.loginAddress = loginAddress;
    }

    @Override
    public String toString() {
        return "UserLoginLog{" +
        "userCode=" + userCode +
        ", wxOpenid=" + wxOpenid +
        ", loginTime=" + loginTime +
        ", loginIp=" + loginIp +
        ", loginLatlng=" + loginLatlng +
        ", loginProvince=" + loginProvince +
        ", loginCity=" + loginCity +
        ", loginDistrict=" + loginDistrict +
        ", loginAddress=" + loginAddress +
        "}";
    }
}
