package com.rocogz.syy.activity.client;

import com.rocogz.syy.activity.entity.*;
import com.rocogz.syy.activity.entity.zh.wash.car.ActivityZhWashCar;
import com.rocogz.syy.activity.entity.zh.wash.car.ActivityZhWashCarReceiveInfo;
import com.rocogz.syy.activity.entity.zh.wash.car.ActivityZhWashCarReceiveRule;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * The interface Activity client service.
 *
 * @author：liangyongtong
 * @since：2020/3/25
 */
public interface IActivityClientService {

    /*********************************************   ranxiangfu 活动基本信息相关接口 start   ********************************************************************/

    /**
     * 分页查询活动基本信息.
     *
     * @param type                       活动类型
     * @param code                       编码
     * @param name                       名称
     * @param issuingBodyCode            发放主体编码
     * @param prefectureCode             专区编码
     * @param status                     活动上下架状态
     * @param progressStatus             活动进行状态
     * @param activityStartTimeStartTime 活动开始时间范围查询-起始时间
     * @param activityStartTimeEndTime   活动开始时间范围查询-结束时间
     * @param activityEndTimeStartTime   活动结束时间范围查询-开始时间
     * @param activityEndTimeEndTime     活动结束时间范围查询-结束时间
     * @param page                       the page
     * @param limit                      the limit
     * @return the page table
     */
    @GetMapping("/api/activity/activity-basic-info/pageQuery")
    PageTable<ActivityBasicInfo> pageQueryActivityBasicInfo(@RequestParam(value = "type", required = false) String type,
                                                            @RequestParam(value = "code", required = false) String code,
                                                            @RequestParam(value = "name", required = false) String name,
                                                            @RequestParam(value = "issuingBodyCode", required = false) String issuingBodyCode,
                                                            @RequestParam(value = "prefectureCode", required = false) String prefectureCode,
                                                            @RequestParam(value = "status", required = false) String status,
                                                            @RequestParam(value = "progressStatus", required = false) String progressStatus,
                                                            @RequestParam(value = "activityStartTimeStartTime", required = false) String activityStartTimeStartTime,
                                                            @RequestParam(value = "activityStartTimeEndTime", required = false) String activityStartTimeEndTime,
                                                            @RequestParam(value = "activityEndTimeStartTime", required = false) String activityEndTimeStartTime,
                                                            @RequestParam(value = "activityEndTimeEndTime", required = false) String activityEndTimeEndTime,
                                                            @RequestParam(value = "page", defaultValue = "1") Integer page,
                                                            @RequestParam(value = "limit", defaultValue = "20") Integer limit);
    /**
     * Gets activity basic info by id.
     *
     * @param id the id
     * @return the activity basic info by id
     */
    @GetMapping("/api/activity/activity-basic-info")
    Response<ActivityBasicInfo> getActivityBasicInfoById(@RequestParam("id") Integer id);

    /**
     * Gets activity basic info by code.
     *
     * @param code the code
     * @return the activity basic info by code
     */
    @GetMapping("/api/activity/activity-basic-info/getByCode")
    Response<ActivityBasicInfo> getActivityBasicInfoByCode(@RequestParam("code") String code);

    /**
     * Save or update activity basic info response.
     *
     * @param activityBasicInfo the activity basic info
     * @return the response
     */
    @PostMapping("/api/activity/activity-basic-info")
    Response<String> saveOrUpdateActivityBasicInfo(@RequestBody ActivityBasicInfo activityBasicInfo);

    /**
     * Delete activity basic info response.
     *
     * @param id the id
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-basic-info")
    Response deleteActivityBasicInfo(@RequestParam("id") Integer id);

    /**
     * Delete activity basic info by code response.
     *
     * @param code 活动编码
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-basic-info/deleteByCode")
    Response deleteActivityBasicInfoByCode(@RequestParam("code") String code);

    /*********************************************   ranxiangfu 活动基本信息相关接口 end   ********************************************************************/

    /*********************************************   ranxiangfu 活动基准券配置相关接口 start   ********************************************************************/

    /**
     * List activity coupon config response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @GetMapping("/api/activity/activity-coupon-config/listByActivityCode")
    Response<List<ActivityCouponConfig>> listActivityCouponConfig(@RequestParam(value = "activityCode") String activityCode);

    /**
     * List available activity coupon config response.
     *
     * @param prefectureCode the prefecture code
     * @param activityCode   the activity code
     * @return the response
     */
    @GetMapping("/api/activity/activity-coupon-config/listAvailable")
    Response<List<ActivityCouponConfig>> listAvailableActivityCouponConfig(@RequestParam(value = "prefectureCode") String prefectureCode,
                                                                           @RequestParam(value = "activityCode", required = false) String activityCode);
    /**
     * Gets activity coupon config by id.
     *
     * @param id the id
     * @return the activity coupon config by id
     */
    @GetMapping("/api/activity/activity-coupon-config")
    Response<ActivityCouponConfig> getActivityCouponConfigById(@RequestParam("id") Integer id);

    /**
     * Gets activity coupon config activity code and coupon code.
     *
     * @param activityCode the activity code
     * @param couponCode   the coupon code
     * @return the activity coupon config activity code and coupon code
     */
    @GetMapping("/api/activity/activity-coupon-config/getByActivityCodeAndCouponCode")
    Response<ActivityCouponConfig> getActivityCouponConfigByActivityCodeAndCouponCode(
            @RequestParam("activityCode") String activityCode, @RequestParam("couponCode") String couponCode);

    /**
     * Save or update activity coupon config response.
     *
     * @param activityCouponConfig the activity coupon config
     * @return the response
     */
    @PostMapping("/api/activity/activity-coupon-config")
    Response saveOrUpdateActivityCouponConfig(@RequestBody ActivityCouponConfig activityCouponConfig);

    /**
     * Batch save or update activity coupon config response.
     *
     * @param activityCouponConfigList the activity coupon config list
     * @return the response
     */
    @PostMapping("/api/activity/activity-coupon-config/batchSaveOrUpdate")
    Response batchSaveOrUpdateActivityCouponConfig(@RequestBody List<ActivityCouponConfig> activityCouponConfigList);

    /**
     * Incr activity coupon config receive quantity response.
     *
     * @param activityCode the activity code
     * @param couponCode   the coupon code
     * @return the response
     */
    @PostMapping("/api/activity/activity-coupon-config/incrReceiveQuantity")
    Response incrActivityCouponConfigReceiveQuantity(@RequestParam(value = "activityCode") String activityCode,
                                                     @RequestParam(value = "couponCode") String couponCode);

    /**
     * Delete activity coupon config response.
     *
     * @param id the id
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-coupon-config")
    Response deleteActivityCouponConfig(@RequestParam("id") Integer id);

    /**
     * Delete activity coupon config by ids response.
     *
     * @param idList the id list
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-coupon-config/deleteByIds")
    Response deleteActivityCouponConfigByIds(@RequestParam("idList") List<Integer> idList);

    /**
     * Delete activity coupon config by activity code response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-coupon-config/deleteByActivityCode")
    Response deleteActivityCouponConfigByActivityCode(@RequestParam("activityCode") String activityCode);

    /*********************************************   ranxiangfu 活动基准券配置相关接口 end   ********************************************************************/

    /*********************************************   ranxiangfu 活动日志相关接口 start   ********************************************************************/

    /**
     * Page query activity log page table.
     *
     * @param activityCode the activity code
     * @param page         the page
     * @param limit        the limit
     * @return the page table
     */
    @GetMapping("/api/activity/activity-log/listByActivityCode")
    PageTable<ActivityLog> pageQueryActivityLog(@RequestParam(value = "activityCode") String activityCode,
                                                @RequestParam(value = "page", defaultValue = "1") Integer page,
                                                @RequestParam(value = "limit", defaultValue = "20") Integer limit);

    /**
     * Save activity log response.
     *
     * @param activityLog the activity log
     * @return the response
     */
    @PostMapping("/api/activity/activity-log")
    Response saveActivityLog(@RequestBody ActivityLog activityLog);

    /*********************************************   ranxiangfu 活动日志相关接口 end   ********************************************************************/

    /*********************************************   ranxiangfu 活动领券规则相关接口 start   ********************************************************************/

    /**
     * List activity receive rule response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @GetMapping("/api/activity/activity-receive-rule/listByActivityCode")
    Response<List<ActivityReceiveRule>> listActivityReceiveRule(@RequestParam(value = "activityCode") String activityCode);

    /**
     * Gets activity receive rule by id.
     *
     * @param id the id
     * @return the activity receive rule by id
     */
    @GetMapping("/api/activity/activity-receive-rule")
    Response<ActivityReceiveRule> getActivityReceiveRuleById(@RequestParam("id") Integer id);

    /**
     * Save or update activity receive rule response.
     *
     * @param activityReceiveRule the activity receive rule
     * @return the response
     */
    @PostMapping("/api/activity/activity-receive-rule")
    Response saveOrUpdateActivityReceiveRule(@RequestBody ActivityReceiveRule activityReceiveRule);

    /**
     * Batch save or update activity receive rule response.
     *
     * @param activityReceiveRuleList the activity receive rule list
     * @return the response
     */
    @PostMapping("/api/activity/activity-receive-rule/batchSaveOrUpdate")
    Response batchSaveOrUpdateActivityReceiveRule(@RequestBody List<ActivityReceiveRule> activityReceiveRuleList);

    /**
     * Delete activity receive rule response.
     *
     * @param id the id
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-receive-rule")
    Response deleteActivityReceiveRule(@RequestParam("id") Integer id);

    /**
     * Delete activity receive rule by ids response.
     *
     * @param idList the id list
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-receive-rule/deleteByIds")
    Response deleteActivityReceiveRuleByIds(@RequestParam("idList") List<Integer> idList);

    /**
     * Delete activity receive rule by activity code response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-receive-rule/deleteByActivityCode")
    Response deleteActivityReceiveRuleByActivityCode(@RequestParam(value = "activityCode") String activityCode);

    /*********************************************   ranxiangfu 活动领券规则相关接口 end   ********************************************************************/

    /*********************************************   ranxiangfu 活动投放专区相关接口 start   ********************************************************************/

    /**
     * List activity available prefecture response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @GetMapping("/api/activity/activity-available-prefecture/listByActivityCode")
    Response<List<ActivityAvailablePrefecture>> listActivityAvailablePrefecture(@RequestParam(value = "activityCode") String activityCode);

    /**
     * Batch save activity available prefecture response.
     *
     * @param activityAvailablePrefectureList the activity available prefecture list
     * @return the response
     */
    @PostMapping("/api/activity/activity-available-prefecture/batchSave")
    Response batchSaveActivityAvailablePrefecture(@RequestBody List<ActivityAvailablePrefecture> activityAvailablePrefectureList);

    /**
     * Remove activity available prefecture by ids response.
     *
     * @param idList the id list
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-available-prefecture")
    Response deleteActivityAvailablePrefectureByIds(@RequestParam(value = "idList") List<Integer> idList);

    /**
     * Remove activity available prefecture by activity code response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-available-prefecture/deleteByActivityCode")
    Response deleteActivityAvailablePrefectureByActivityCode(@RequestParam(value = "activityCode") String activityCode);

    /*********************************************   ranxiangfu 活动投放专区相关接口 end   ********************************************************************/
    /*********************************************   ranxiangfu 活动优惠券用户领取信息相关接口 start   ********************************************************************/
    /**
     * Save activity user coupon receive info response.
     *
     * @param activityUserCouponReceiveInfo the activity user coupon receive info
     * @return the response
     */
    @PostMapping("/api/activity/activity-user-coupon-receive-info")
    Response saveActivityUserCouponReceiveInfo(@RequestBody ActivityUserCouponReceiveInfo activityUserCouponReceiveInfo);

    /**
     * List user receive coupon info response.
     *
     * @param userCode         the user code
     * @param activityCodeList the activity code list
     * @param couponCodeList   the coupon code list
     * @return the response
     */
    @GetMapping("/api/activity/activity-user-coupon-receive-info/list")
    Response<List<ActivityUserCouponReceiveInfo>> listUserReceiveCouponInfo(@RequestParam("userCode") String userCode,
                                                                            @RequestParam("activityCodeList") List<String> activityCodeList,
                                                                            @RequestParam("couponCodeList") List<String> couponCodeList);

    /**
     * Count user receive coupon num response.
     *
     * @param userCode     the user code
     * @param activityCode the activity code
     * @param couponCode   the coupon code
     * @return the response
     */
    @GetMapping("/api/activity/activity-user-coupon-receive-info/countUserReceiveCouponNum")
    Response<Integer> countUserReceiveCouponNum(@RequestParam(value = "userCode", required = false) String userCode,
                                                @RequestParam("activityCode") String activityCode,
                                                @RequestParam("couponCode") String couponCode);
    /*********************************************   ranxiangfu 活动优惠券用户领取信息相关接口 end   ********************************************************************/

    /*********************************************   ranxiangfu 珠海9块9洗车相关接口 start   ********************************************************************/
    /**
     * Gets activity zh wash car info by code.
     *
     * @param code the code
     * @return the activity zh wash car info by code
     */
    @GetMapping("/api/activity/activity-zh-wash-car/getByCode")
    Response<ActivityZhWashCar> getActivityZhWashCarInfoByCode(@RequestParam("code") String code);

    /**
     * Save or update activity zh wash car response.
     *
     * @param zhWashCar the zh wash car
     * @return the response
     */
    @PostMapping("/api/activity/activity-zh-wash-car")
    Response<String> saveOrUpdateActivityZhWashCar(@RequestBody ActivityZhWashCar zhWashCar);

    /**
     * Delete activity zh wash car response.
     *
     * @param id the id
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-zh-wash-car")
    Response deleteActivityZhWashCar(@RequestParam("id") Integer id);

    /**
     * Delete activity zh wash car by code response.
     *
     * @param code the code
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-zh-wash-car/deleteByCode")
    Response deleteActivityZhWashCarByCode(@RequestParam("code") String code);

    /*********************************************   ranxiangfu 珠海9块9洗车相关接口 end   ********************************************************************/

    /*********************************************   ranxiangfu 珠海9块9洗车领取规则相关接口 start   ********************************************************************/

    /**
     * List activity zh wash car receive rule response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @GetMapping("/api/activity/activity-zh-wash-car-receive-rule/listByActivityCode")
    Response<List<ActivityZhWashCarReceiveRule>> listActivityZhWashCarReceiveRule(@RequestParam(value = "activityCode") String activityCode);

    /**
     * Gets activity zh wash car receive rule by id.
     *
     * @param id the id
     * @return the activity zh wash car receive rule by id
     */
    @GetMapping("/api/activity/activity-zh-wash-car-receive-rule")
    Response<ActivityZhWashCarReceiveRule> getActivityZhWashCarReceiveRuleById(@RequestParam("id") Integer id);

    /**
     * Save or update activity zh wash car receive rule response.
     *
     * @param activityReceiveRule the activity receive rule
     * @return the response
     */
    @PostMapping("/api/activity/activity-zh-wash-car-receive-rule")
    Response saveOrUpdateActivityZhWashCarReceiveRule(@RequestBody ActivityZhWashCarReceiveRule activityReceiveRule);

    /**
     * Batch save or update activity zh wash car receive rule response.
     *
     * @param activityReceiveRuleList the activity receive rule list
     * @return the response
     */
    @PostMapping("/api/activity/activity-zh-wash-car-receive-rule/batchSaveOrUpdate")
    Response batchSaveOrUpdateActivityZhWashCarReceiveRule(@RequestBody List<ActivityZhWashCarReceiveRule> activityReceiveRuleList);

    /**
     * Delete activity zh wash car receive rule response.
     *
     * @param id the id
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-zh-wash-car-receive-rule")
    Response deleteActivityZhWashCarReceiveRule(@RequestParam("id") Integer id);

    /**
     * Delete activity zh wash car receive rule by ids response.
     *
     * @param idList the id list
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-zh-wash-car-receive-rule/deleteByIds")
    Response deleteActivityZhWashCarReceiveRuleByIds(@RequestParam("idList") List<Integer> idList);

    /**
     * Delete activity zh wash car receive rule by activity code response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-zh-wash-car-receive-rule/deleteByActivityCode")
    Response deleteActivityZhWashCarReceiveRuleByActivityCode(@RequestParam(value = "activityCode") String activityCode);
    /*********************************************   ranxiangfu 珠海9块9洗车领取规则相关接口 end   ********************************************************************/

    /*********************************************   ranxiangfu 珠海9块9洗车优惠券领取记录相关接口 start   ********************************************************************/
    /**
     * Save activity zh wash car receive info response.
     *
     * @param activityUserCouponReceiveInfo the activity user coupon receive info
     * @return the response
     */
    @PostMapping("/api/activity/activity-zh-wash-car-receive-info")
    Response saveActivityZhWashCarReceiveInfo(@RequestBody ActivityZhWashCarReceiveInfo activityUserCouponReceiveInfo);

    /**
     * List user receive coupon info response.
     *
     * @param userCode         the user code
     * @param activityCodeList the activity code list
     * @param couponCodeList   the coupon code list
     * @return the response
     */
    @GetMapping("/api/activity/activity-zh-wash-car-receive-info/list")
    Response<List<ActivityZhWashCarReceiveInfo>> listActivityZhWashCarReceiveInfo(@RequestParam("userCode") String userCode,
                                                                                         @RequestParam("activityCodeList") List<String> activityCodeList,
                                                                                         @RequestParam("couponCodeList") List<String> couponCodeList);

    /**
     * Count user receive coupon num response.
     *
     * @param userCode           the user code
     * @param couponCode         the coupon code
     * @param activityCode       the activity code
     * @param licensePlateNumber the license plate number
     * @param startTime          the start time
     * @param endTime            the end time
     * @return the response
     */
    @GetMapping("/api/activity/activity-zh-wash-car-receive-info/count")
    Response<Integer> countActivityZhWashCarReceiveInfo(@RequestParam(value = "userCode", required = false) String userCode,
                                                        @RequestParam(value = "couponCode", required = false) String couponCode,
                                                        @RequestParam(value = "activityCode", required = false) String activityCode,
                                                        @RequestParam(value = "licensePlateNumber", required = false) String licensePlateNumber,
                                                        @RequestParam(value = "startTime", required = false) String startTime,
                                                        @RequestParam(value = "endTime", required = false) String endTime);
    /*********************************************   ranxiangfu 珠海9块9洗车优惠券领取记录相关接口 end   ********************************************************************/
}
