package com.rocogz.syy.activity.entity.zh.wash.car;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 活动中心-珠海9块9洗车活动配置信息
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-06-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("activity_zh_wash_car")
public class ActivityZhWashCar extends UserTimeEntity {

    private static final long serialVersionUID = -6017517929967803392L;
    /**
     * 活动编码
     */
    private String code;

    /**
     * 活动主体
     */
    private String issuingBodyCode;

    /**
     * 活动开始时间
     */
    private LocalDateTime startTime;

    /**
     * 活动结束时间
     */
    private LocalDateTime endTime;

    /**
     * 用于会员领的基准券编码
     */
    private String vipCouponCode;

    /**
     * 用于会员领的基准券名称
     */
    private String vipCouponName;

    /**
     * 用于会员领的基准券总数量
     */
    private Integer vipCouponTotalQuantity;

    /**
     * 用于会员领的基准券已领取数量
     */
    private Integer vipCouponReceiveQuantity;

    /**
     * 用于普通用户领的基准券编码
     */
    private String normalCouponCode;

    /**
     * 用于普通用户领的基准券名称
     */
    private String normalCouponName;

    /**
     * 用于普通用户领的基准券总数量
     */
    private Integer normalCouponTotalQuantity;

    /**
     * 用于普通用户领的基准券已领取数量
     */
    private Integer normalCouponReceiveQuantity;

    /**
     * 备注
     */
    private String activityComment;


}
