package com.rocogz.syy.activity.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;

import java.io.Serializable;
import java.time.LocalDateTime;

import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 活动中心-活动操作日志
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-04-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("activity_log")
public class ActivityLog extends UserTimeEntity implements Serializable {

    private static final long serialVersionUID = -2079836555915048210L;
    /**
     * 活动编码
     */
    private String activityCode;

    /**
     * 日志类型
     */
    private String type;

    /**
     * 日志内容
     */
    private String content;

    /**
     * 请求参数
     */
    private String requestParam;

}
