package com.rocogz.syy.activity.entity.reo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 权益线上领取活动-礼包信息表
 * </p>
 *
 * @author ranxiangfu
 * @since 2022-01-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("activity_reo_gift_info")
public class ActivityReoGiftInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 活动编号
     */
    private String activityCode;

    /**
     * 礼包编号
     */
    private String code;

    /**
     * 礼包名称
     */
    private String name;

    /**
     * 礼包价值
     */
    private BigDecimal giftWorth;

    /**
     * 投放数量
     */
    private Integer launchQuantity;

    /**
     * 已领取数量
     */
    private Integer receivedQuantity;

    /**
     * 状态
     */
    private String status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建人名称
     */
    @TableField(exist = false)
    private String createUserNickname;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新人名称
     */
    @TableField(exist = false)
    private String updateUserNickname;

    /**
     * 礼包产品信息列表
     */
    @TableField(exist = false)
    private List<ActivityReoGiftProductInfo> giftProductInfos;
}
