package com.rocogz.syy.activity.entity.send;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 赠送活动参与明细
 * </p>
 *
 * @author yinshihao
 * @since 2021-08-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class ActivitySendJoinDetail extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 明细编码
     */
    private String code;

    /**
     * 活动参与记录编码
     */
    private String joinLogCode;

    /**
     * 产品编码(服务商产品)
     */
    private String goodsCode;

    /**
     * 服务商产品名称
     */
    @TableField(exist = false)
    private String goodsName;

    /**
     * 所属服务商编码
     */
    @TableField(exist = false)
    private String agentCode;

    /**
     * 所属服务商名称
     */
    @TableField(exist = false)
    private String agentName;

    /**
     * 服务商产品类型
     */
    @TableField(exist = false)
    private String goodsType;

    /**
     * 服务商产品面值
     */
    @TableField(exist = false)
    private BigDecimal goodsMarketPrice;

    /**
     * 错误信息(调用其他服务下单时报的错误信息)
     */
    private String errorMsg;

    /**
     * 赠送数量
     */
    private Integer sendNum;

    /**
     * 状态
     */
    private String status;

    /**
     * 完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 撤销时间
     */
    private LocalDateTime revertTime;
}
