package com.rocogz.syy.activity.dto.reo;

import com.rocogz.syy.activity.constant.ActivityConstant;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description: reo活动信息列表查询dto
 * @date：2022/1/17
 * @author：huangdeyi
 */
@Data
public class ReoInfoSearchDto {

    /**
     * @see ActivityConstant.DictReoActivityType#REO_ACTIVITY_SIGIN
     */
    private String activityType;

    /**
     * 活动编号
     */
    private String code;

    /**
     * 活动名称
     */
    private String name;

    /**
     * 投放平台编码列表
     */
    private List<String> miniAppids;

    /**
     * 发放主体编码列表
     */
    private List<String> issuingBodyCodes;

    /**
     * 活动开始时间最小值
     */
    private String startTimeMinTime;

    /**
     * 活动开始时间最大值
     */
    private String startTimeMaxTime;

    /**
     * 活动结束时间最小值
     */
    private String endTimeMinTime;

    /**
     * 活动结束时间最大值
     */
    private String endTimeMaxTime;

    /**
     * 活动进行状态(未开始：NOT_STARTED、进行中：NOT_STARTED、已结束：END)
     */
    private String progressStatus;

    /**
     * 当前时间
     */
    private LocalDateTime now;

    /**
     * 活动上架状态
     */
    private String status;

    /**
     * 当前页
     */
    private int page;

    /**
     * 每页记录数
     */
    private int limit;
}
