package com.rocogz.syy.activity.dto.reo;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * @author djt
 * @date 2022/1/11
 */
@Data
@Accessors(chain = true)
public class ReoReceiveRecordUpdateReq {

    /**
     * 领取记录明细编号
     */
    @NotBlank(message = "领取记录明细编号不能为空")
    private String recordItemCode;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 错误信息
     */
    private String errorMsg;

}
