package com.rocogz.syy.activity.constant;

import java.time.format.DateTimeFormatter;

/**
 * <dl>
 * <dd>Description: 用户中心服务常量类</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/4/22 17:03</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
public final class ActivityConstant {
    private ActivityConstant(){}

    /**
     * 日期时间格式化
     */
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    /**
     * redisKey前缀
     */
    public static final String ACTIVITY_KEY_PREFIX = "ACTIVITY:";
    public static final String ACTIVITY_RECEIVE_ONLINE_KEY_PREFIX = "ACTIVITY:RECEIVE_ONLINE:";
    public static final String ACTIVITY_RECEIVE_ONLINE_RECEIVE_INFO_KEY_PREFIX = "ACTIVITY:RECEIVE_ONLINE:RECEIVE_INFO:";
    public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_LIST_KEY_PREFIX = "ACTIVITY:RECEIVE_ONLINE:COUPON_LIST:";
    public static final String ACTIVITY_BASIC_INFO_KEY_PREFIX = "ACTIVITY:BASIC_INFO:";
    public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_CONFIG_KEY_PREFIX = "ACTIVITY:RECEIVE_ONLINE:COUPON_CONFIG:";
    public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_CONFIG_REMAINING_QUANTITY_KEY_PREFIX = "ACTIVITY:RECEIVE_ONLINE:COUPON_CONFIG:REMAINING_QUANTITY:";
    public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_CONFIG_RECEIVE_ERROR_QUANTITY_KEY_PREFIX = "ACTIVITY:RECEIVE_ONLINE:COUPON_CONFIG:RECEIVE_ERROR_QUANTITY:";
    public static final String ACTIVITY_RECEIVE_ONLINE_RULE_CONFIG_KEY_PREFIX = "ACTIVITY:RECEIVE_ONLINE:RULE_CONFIG:";
    public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_CONFIG_LIST_KEY_PREFIX = "ACTIVITY:RECEIVE_ONLINE:COUPON_CONFIG:LIST:";
    public static final String ACTIVITY_RECEIVE_ONLINE_RULE_CONFIG_LIST_KEY_PREFIX = "ACTIVITY:RECEIVE_ONLINE:RULE_CONFIG:LIST:";
    public static final String ACTIVITY_UP_LIST_SEND_ACTIVE_LIST_KEY_PREFIX = "ACTIVITY:UP_LIST_SEND_ACTIVE:LIST:";

    /** 珠海9块9洗车活动前缀 **/
    public static final String ACTIVITY_ZH_WASH_CAR_KEY_PREFIX = "ACTIVITY:ZH_WASH_CAR:";
    public static final String ACTIVITY_ZH_WASH_CAR_LOCK_KEY_PREFIX = "ACTIVITY:ZH_WASH_CAR:LOCK:";
    public static final String ACTIVITY_ZH_WASH_CAR_RECEIVE_RULE_LIST_KEY_PREFIX = "ACTIVITY:ZH_WASH_CAR:RECEIVE_RULE:LIST:";

    /**
     * MQ交换器名称
     */
    public static final String MQ_EXCHANGE_NAME = "ACTIVITY_EXCHANGE";

    /**
     * 线上领券领取信息消息队列
     */
    public static final String MQ_RECEIVE_ONLINE_RECEIVE_INFO_QUEUE = "ACTIVITY_RECEIVE_ONLINE_RECEIVE_INFO";

    /**
     * 线上领券领取信息路由名称
     */
    public static final String MQ_RECEIVE_ONLINE_RECEIVE_INFO_ROUTE_KEY = "ACTIVITY_RECEIVE_ONLINE_RECEIVE_INFO";

    /**
     * 字典值
     */
    public class DictData {
        private DictData(){}

        /**
         * 通用启用、停用
         */
        public static final String COMMON_STATUS_OPEN_CODE = "OPEN";
        public static final String COMMON_STATUS_LOCK_CODE = "LOCK";

        /**
         * 通用是否
         */
        public static final String COMMON_YES = "Y";
        public static final String COMMON_NO = "N";

        /**
         * 活动领券规则字典表编码
         */
        public static final String ACTIVITY_RECEIVE_RULE_CODE = "ACTIVITY_RECEIVE_RULE";

        /**
         * 活动领券规则字典值编码
         */
        public static final String ACTIVITY_RECEIVE_RULE_BEFORE_REGISTER_TIME_CODE = "BEFORE_REGISTER_TIME";
        public static final String ACTIVITY_RECEIVE_RULE_AFTER_REGISTER_TIME_CODE = "AFTER_REGISTER_TIME";
        public static final String ACTIVITY_RECEIVE_RULE_REGISTER_TIME_START_CODE = "REGISTER_TIME_START";
        public static final String ACTIVITY_RECEIVE_RULE_REGISTER_TIME_END_CODE = "REGISTER_TIME_END";
        public static final String ACTIVITY_RECEIVE_RULE_CA_MOBILE_CODE = "CA_MOBILE";
        public static final String ACTIVITY_RECEIVE_RULE_CA_CAR_CODE = "CA_CAR";
        public static final String ACTIVITY_RECEIVE_RULE_CORPORATE_CUSTOMER_CODE = "CORPORATE_CUSTOMER";
        public static final String ACTIVITY_RECEIVE_RULE_ALL_CUSTOMER_CODE = "ALL_CUSTOMER";

        /**
         * 领券规则值
         */
        public static final String ACTIVITY_RECEIVE_RULE_VALUE_Y = "Y";
        public static final String ACTIVITY_RECEIVE_RULE_VALUE_N = "N";

        /**
         * 活动进行状态：DICT_TYPE_CODE= ACTIVITY_PROGRESS_STATUS
         */
        public static final String ACTIVITY_PROGRESS_STATUS_NOT_STARTED_CODE = "NOT_STARTED";
        public static final String ACTIVITY_PROGRESS_STATUS_IN_PROGRESS_CODE = "IN_PROGRESS";
        public static final String ACTIVITY_PROGRESS_STATUS_END_CODE = "END";

        /**
         * 活动上下架状态: DICT_TYPE_CODE= ACTIVITY_STATUS
         */
        public static final String ACTIVITY_STATUS_DRAFT_CODE = "DRAFT";
        public static final String ACTIVITY_STATUS_STAYINGON_CODE = "STAYINGON";
        public static final String ACTIVITY_STATUS_UP_LIST_CODE = "UP_LIST";
        public static final String ACTIVITY_STATUS_DOWN_LIST_CODE = "DOWN_LIST";
        public static final String ACTIVITY_STATUS_INVALID_CODE = "INVALID";
        //编辑页面 待上架状态保存，临时状态
        public static final String ACTIVITY_STATUS_EDIT_STAYINGON_CODE = "EDIT_STAYINGON";

        /**
         * 线上领券活动基准券配置上下架状态:
         */
        public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_STATUS_STAYINGON_CODE = "STAYINGON";
        public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_STATUS_UP_LIST_CODE = "UP_LIST";
        public static final String ACTIVITY_RECEIVE_ONLINE_COUPON_STATUS_DOWN_LIST_CODE = "DOWN_LIST";

        /**
         * 珠海9块9洗车活动，领取限制-时间范围类型
         */
        public static final String ACTIVITY_ZH_WASH_CAR_TIME_RANGE_TYPE_FOR_EVEY = "FOR_EVEY";
        public static final String ACTIVITY_ZH_WASH_CAR_TIME_RANGE_TYPE_YEARLY = "YEARLY";
        public static final String ACTIVITY_ZH_WASH_CAR_TIME_RANGE_TYPE_QUARTERLY = "QUARTERLY";
        public static final String ACTIVITY_ZH_WASH_CAR_TIME_RANGE_TYPE_MONTHLY = "MONTHLY";
        public static final String ACTIVITY_ZH_WASH_CAR_TIME_RANGE_TYPE_WEEKLY = "WEEKLY";
        public static final String ACTIVITY_ZH_WASH_CAR_TIME_RANGE_TYPE_DAILY = "DAILY";

        /**
         * 活动领券模式字典编码
         */
        public static final String ACTIVITY_COUPON_RECEIVE_PATTERN_CODE = "ACTIVITY_COUPON_RECEIVE_PATTERN";
        /**
         * 活动领券模式-普通模式
         */
        public static final String ACTIVITY_COUPON_RECEIVE_PATTERN_NORMAL_CODE = "NORMAL_PATTERN";
        /**
         * 活动领券模式-口令模式
         */
        public static final String ACTIVITY_COUPON_RECEIVE_PATTERN_PASSWORD_CODE = "PASSWORD_PATTERN";

        /**
         * 活动优惠券领取类型
         */
        public static final String ACTIVITY_COUPON_RECEIVE_TYPE_CODE = "ACTIVITY_COUPON_RECEIVE_TYPE";
        /**
         * 活动优惠券领取类型-按车领
         */
        public static final String ACTIVITY_COUPON_RECEIVE_TYPE_BY_CAR_CODE = "BY_CAR";
        /**
         * 活动优惠券领取类型-按人领
         */
        public static final String ACTIVITY_COUPON_RECEIVE_TYPE_BY_PEOPLE_CODE = "BY_PEOPLE";

        /**
         * 距离类型字典值
         */
        public static final String DISTANCE_TYPE = "DISTANCE_TYPE";

        /**
         * 签到距离字典值
         */
        public static final String SIGNIN_DISTANCE = "SIGNIN_DISTANCE";
    }

    /** 赠送活动参与记录状态字典值编码 **/
    public static final String SEND_ACTIVITY_STATUS_TYPE_CODE = "SEND_ACTIVITY_JOIN_LOG_STATUS";

    /** 赠送活动参与记录状态: 待发放**/
    public static final String SEND_ACTIVITY_STATUS_TO_BE_ISSUED = "TO_BE_ISSUED";

    /** 赠送活动参与记录状态: 发放中**/
    public static final String SEND_ACTIVITY_STATUS_ISSUING = "ISSUING";

    /** 赠送活动参与记录状态: 已发放**/
    public static final String SEND_ACTIVITY_STATUS_ISSUED = "ISSUED";

    /** 赠送活动参与记录状态: 已撤销**/
    public static final String SEND_ACTIVITY_STATUS_REVERT = "REVERT";

    /** 赠送活动参与记录状态: 撤销中**/
    public static final String SEND_ACTIVITY_STATUS_REVERTING = "REVERTING";

    /** 赠送活动参与记录状态: 部分撤销**/
    public static final String SEND_ACTIVITY_STATUS_PARTIAL_REVERT = "PARTIAL_REVERT";

    /** 赠送活动参与记录状态: 撤销失败**/
    public static final String SEND_ACTIVITY_STATUS_REVERT_FAIL = "REVERT_FAIL";

    /**
     * 赠送活动参与记录下单队列
     */
    public static final String SEND_ACTIVITY_JOIN_INFO_ORDER_QUEUE = "SEND_ACTIVITY_JOIN_INFO_ORDER_QUEUE";

    /**
     * 赠送活动参与记录下单ROUTE_KEY
     */
    public static final String SEND_ACTIVITY_JOIN_INFO_ORDER_ROUTE_KEY = "SEND_ACTIVITY_JOIN_INFO_ORDER_ROUTE_KEY";

    /**
     * 赠送活动参与记录撤销队列
     */
    public static final String SEND_ACTIVITY_JOIN_INFO_REVERT_QUEUE = "SEND_ACTIVITY_JOIN_INFO_REVERT_QUEUE";

    /**
     * 赠送活动参与记录撤销ROUTE_KEY
     */
    public static final String SEND_ACTIVITY_JOIN_INFO_REVERT_ROUTE_KEY = "SEND_ACTIVITY_JOIN_INFO_REVERT_ROUTE_KEY";

    /**
     * 权益线上领券活动下单队列
     */
    public static final String RECEIVE_EQUITY_ONLINE_ACTIVITY_ORDER_QUEUE = "RECEIVE_EQUITY_ONLINE_ACTIVITY_ORDER_QUEUE";

    /**
     * 权益线上领券活动下单ROUTE_KEY
     */
    public static final String RECEIVE_EQUITY_ONLINE_ACTIVITY_ORDER_ROUTE_KEY = "RECEIVE_EQUITY_ONLINE_ACTIVITY_ORDER_ROUTE_KEY";


    /**
     * 获取活动类型
     */
    public static final class DictReoActivityType {

        /**
         * 字典值
         */
        public static final String  TYPE_CODE= "REO_ACTIVITY_TYPE";

        /**
         * 权益线上领取活动,也就是：特斯拉活动
         */
        public static final String REO_ACTIVITY_TESLA = "TESLA";

        /**
         * 签到活动
         */
        public static final String REO_ACTIVITY_SIGIN  = "SIGIN";

        /**
         * 团购活动
         */
        public static final String REO_ACTIVITY_GROUP  = "GROUP";
    }


    /**
     * 礼包数量调整类型
     */
    public static final class ReoModifyGiftQuantityReqType {
        /**
         * 增加
         */
        public static final String ADD = "ADD";

        /**
         * 减少
         */
        public static final String SUBTRACT = "SUBTRACT";
    }


    /**
     * 礼包产品性质
     */
    public static final class ReoProductNature{

        /**
         * 字典值
         */
        public static final String TYPE_CODE= "REO_PRODUCT_NATURE";

        /**
         * 分销产品
         */
        public static final String REO_PRODUCT_NATURE_SCM = "SCM";

        /**
         * 实物商品
         */
        public static final String REO_PRODUCT_NATURE_GOOD = "GOOD";
    }

    /**
     * 礼包产品类型
     */
    public static final class ReoProductType {
        /**
         * 电子油卡券固定面额
         */
        public static final String REO_PRODUCT_TYPE_OIL_CARD_DIGITAL = "OIL_CARD_DIGITAL";

        /**
         * 电子油卡券非固定面额
         */
        public static final String REO_PRODUCT_TYPE_OIL_CARD_DIGITAL_YES = "OIL_CARD_DIGITAL_YES";
    }

    /**
     * 礼包领取记录地址状态
     */
    public static final class ReoRecordAddressStatus{

        /**
         * 字典值
         */
        public static final String  TYPE_CODE= "REO_RECORD_ADDRESS_STATUS";

        /**
         * 虚拟产品
         */
        public static final String VIRTUAL = "VIRTUAL";

        /**
         * 已填写地址
         */
        public static final String FILL_ADDRESS = "FILL_ADDRESS";

        /**
         * 未填写地址
         */
        public static final String PENDING_SET_ADDRESS = "PENDING_SET_ADDRESS";


    }

    /**
     * 预约到店时间段
     */
    public static final class AppointmentArrivalTimePart{

        /**
         * 字典值
         */
        public static final String TYPE_CODE = "APPOINTMENT_ARRIVAL_TIME_PART";

        /**
         * 不定上下午
         */
        public static final String NOT_MORNING_OR_AFTERNOON = "NOT_MORNING_OR_AFTERNOON";

        /**
         * 上午
         */
        public static final String MORNING = "MORNING";

        /**
         * 下午
         */
        public static final String AFTERNOON = "AFTERNOON";
    }

    /**
     * 邀约活动类型
     */
    public static final class InviteActivityType{

        /**
         * 字典值
         */
        public static final String TYPE_CODE = "INVITEA_CTIVITY_TYPE";

        /**
         * 参加活动
         */
        public static final String ENTER_INTO_ACTIVITIES = "ENTER_INTO_ACTIVITIES";

        /**
         * 保养
         */
        public static final String MAINTAIN = "MORNING";

        /**
         * 其他
         */
        public static final String OTHER = "AFTERNOON";
    }

    /**
     * 签到状态
     */
    public static final class SignInStatus{

        /**
         * 字典值
         */
        public static final String TYPE_CODE = "SIGN_IN_STATUS";

        /**
         * 待签到
         */
        public static final String SIGN_IN_PENDING = "SIGN_IN_PENDING";

        /**
         * 没签到
         */
        public static final String SIGN_IN_NOT = "SIGN_IN_NOT";

        /**
         * 已签到
         */
        public static final String SIGN_IN_SUCCESS = "SIGN_IN_SUCCESS";
    }

    /**
     * 客户邀约到店登记管理操作项
     */
    public static final class InviteRegistrationManagementOperation{

        /**
         * 字典值
         */
        public static final String TYPE_CODE = "INVITE_REGISTRATION_MANAGEMENT_OPERATION";

        /**
         * 新增邀约
         */
        public static final String ADD = "ADD";
        public static final String ADD_LABEL = "新增邀约";

        /**
         * 编辑
         */
        public static final String EDIT = "EDIT";
        public static final String EDIT_LABEL = "编辑";

        /**
         * 签到
         */
        public static final String SIGN_IN = "SIGN_IN";
        public static final String SIGN_IN_LABEL = "签到";
    }

    /**
     * 团购活动核销状态
     */
    public static final class ActivityGroupParticipantsStatus{

        /**
         * 字典值
         */
        public static final String TYPE_CODE = "ACTIVITY_GROUP_PARTICIPANTS_STATUS";

        /**
         * 待核销
         */
        public static final String NORMAL = "0";

        /**
         * 待支付
         */
        public static final String PENDING_PAY = "-1";

        /**
         * 已核销
         */
        public static final String VERIFICATION = "1";
    }
}
