package com.rocogz.syy.activity.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 活动中心-活动用户券领取信息
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-05-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("activity_user_coupon_receive_info")
public class ActivityUserCouponReceiveInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 活动编码
     */
    private String activityCode;

    /**
     * 基准券编码
     */
    private String couponCode;

    /**
     * 用户券编码
     */
    private String userCouponCode;

    /**
     * 领取时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+08:00"
    )
    private LocalDateTime receiveTime;


}
