package com.rocogz.syy.activity.entity.reo.receive;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 川分员工之家 领取验证活动 礼品基类
 * @author zhangmin
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@Setter @Getter
@Accessors(chain = true)
public abstract class ActivityReceiveBaseGift extends IdEntity {

    /**
     * 客户产品编号
     */
    private String customerProductCode;

    /**
     * 客户产品名称
     */
    private String customerProductName;

    /**
     * 产品类型：OIL_CARD_DIGITAL（固定面额油卡）
     * @see com.rocogz.merchant.entity.goods.MerchantGoods#goodsType
     * 例如：com.rocogz.merchant.constant.Constant.DictData#PRODUCT_TYPE_OIL_CARD_DIGITAL
     */
    private String productType;

    /**
     * 平台产品的 面额/市场价
     * @see com.rocogz.merchant.entity.goods.MerchantGoods#marketPrice
     */
    private BigDecimal faceValue;

    /**
     * 数量
     */
    private Integer quantity;

    /**
     * 使用有效期天数
     */
    private Integer useValidity;




}
