package com.rocogz.syy.activity.entity.reo.receive;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.*;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 川分员工之家领取审核活动 车险附件
 * </p>
 *
 * @author zhangmin
 * @since 2023-04-12
 */
@Setter
@Getter
@NoArgsConstructor
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ActivityReceiveAuditAttach extends IdEntity {

    /**
     * 领取审核活动 参与记录 附件
     */
    public static final String ACTIVITY_RECEIVE_JOIN_RECORD = "JOIN_RECORD";

    /**
     * 领取审核活动参与记录 审核内容附件
     */
    public static final String ACTIVITY_RECEIVE_AUDIT_CONTENT = "AUDIT_CONTENT";


    /**
     * 活动参与记录
     */
    private String joinCode;

    /**
     * 附近类型：参与记录的附件 或 审核记录对应的审核内容附件
     * @see ActivityReceiveAuditAttach#ACTIVITY_RECEIVE_JOIN_RECORD
     */
    private String attachType;

    /**
     * 活动参与记录的审核记录id
     * @see ActivityReceiveAuditRecord#id
     */
    private Integer auditRecordId;

    /**
     * 上传的文件名
     */
    private String uploadName;

    /**
     * 评价上传的图片附件
     */
    private String imgUrl;

    /**
     * 文档大小
     */
    private Integer fileSize;

    /**
     * 文件说明
     */
    private String description;

    /**
     * 图片顺序
     */
    private Integer seq;

    /**
     * 创建人,活动参与人会员编号
     * @see ActivityReceiveJoiner#joinerCode
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


}
