package com.rocogz.syy.activity.dto.send.request;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author djt
 * @date 2021/8/13
 */
@Data
@Accessors(chain = true)
public class SendActivityJoinLogSearchReq  {

    /**
     * 参与记录编码
     */
    private String code;

    /**
     * 用户手机号
     */
    private String userPhone;


    /**
     * 活动编码
     */
    private String activityCode;


    /**
     * 投放平台miniAppid
     */
    private List<String> putPlatformMiniAppid;

    /**
     * 赠送发放主体编码
     */
    private List<String> issuingBodyCodes;

    /**
     * 活动参与开始时间
     */
    private String joinStartTime;

    /**
     * 活动参与结束时间
     */
    private String joinEndTime;

    /**
     * 参与状态
     */
    private String status;

    /**
     * 当前页
     */
    private int page=1;

    /**
     * 页大小
     */
    private int limit=10;


    public Map<String,Object> toMap(){
        Map<String, Object> params = new HashMap<>();
        if (StringUtils.hasLength(this.code)){
            params.put("code","%"+ this.code+"%");
        }
        if (StringUtils.hasLength(this.userPhone)){
            params.put("userPhone","%"+ this.userPhone+"%");
        }
        if (StringUtils.hasLength(this.activityCode)){
            params.put("activityCode","%"+ this.activityCode+"%");
        }
        if (!CollectionUtils.isEmpty(this.putPlatformMiniAppid)){
            params.put("putPlatformMiniAppid",this.putPlatformMiniAppid);
        }
        if (!CollectionUtils.isEmpty(this.issuingBodyCodes)){
            params.put("issuingBodyCodes",this.issuingBodyCodes);
        }
        if (Objects.nonNull(this.joinStartTime)){
            params.put("joinStartTime",this.joinStartTime);
        }
        if (Objects.nonNull(this.joinEndTime)){
            params.put("joinEndTime",this.joinEndTime);
        }
        if (StringUtils.hasLength(this.status)){
            params.put("status", this.status);
        }
        return params;

    }

}
