package com.rocogz.syy.charge.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: C端充电账户表
 * @date：2023/02/27
 * @author：
 */
@Data
@Accessors(chain = true)
@TableName("charge_account")
public class ChargeAccount extends IdEntity {

    private static final long serialVersionUID = -91812560737659324L;

    /**
    * 卡号
    */
    private String code;
    
    /**
    * 手机号
    */
    private String mobile;
    
    /**
    * 类型（字典，字典编号：CHARGE_ACCOUNT_TYPE）
    */
    private String accountType;
    
    /**
    * 总额度
    */
    private BigDecimal totalQuota;
    
    /**
    * 可用额度
    */
    private BigDecimal availableQuota;

    /**
     * 充值中金额
     */
    private BigDecimal chargingQuota;
    
    /**
    * 已用额度
    */
    private BigDecimal usedQuota;
    
    /**
    * 过期额度
    */
    private BigDecimal expireQuota;
    
    /**
    * 冻结额度
    */
    private BigDecimal freezeQuota;
    
    /**
    * 作废额度
    */
    private BigDecimal cancelQuota;
    
    /**
    * 比例
    */
    private BigDecimal scale;
    
    /**
    * 状态
    */
    private String status;
    
    /**
    * 创建人
    */
    private String createUser;
    
    /**
    * 创建时间
    */
    private LocalDateTime createTime;
}