package com.rocogz.syy.common.aliyunoss.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 阿里云 SSO 配置
 * @author：liangyongtong
 * @since：2020/3/28
 */
@ConfigurationProperties(prefix = "aliyun.oss.config")
public class AliyunOssProperties {
    /**
     * 用户保存对象的bucket的名称
     */
    private String bucket;
    /**
     * endpoint根据region的实际情况配置
     */
    private String endpoint;
    /**
     * 权限认证：AccessKeyId
     */
    private String accessKeyId;
    /**
     * 权限认证：AccessKeySecret
     */
    private String accessKeySecret;

    public String getBucket() {
        return bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAccessKeyId() {
        return accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }
}
