package com.rocogz.syy.common.tencent;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

/**
 * @author zhangmin
 * 经纬度
 */
public final class LngLat {

    public static final String SPLITER = ",";

    /**
     * 经度
     */
    private double lng;

    /**
     * 纬度
     */
    private double lat;

    public LngLat() {
    }

    /**
     * @param lng 经度
     * @param lat 纬度
     */
    public LngLat(double lng, double lat) {
        this.lng = lng;
        this.lat = lat;
    }

    public LngLat(String lng, String lat) {
        this(NumberUtils.toDouble(lng), NumberUtils.toDouble(lat));
    }

    //纬度,经度 字符串
    public static LngLat parseLatLng(String latLngStr) {
        if (StringUtils.isEmpty(latLngStr) || !latLngStr.contains(SPLITER)) {
            return null;
        }
        String[] array = latLngStr.split(SPLITER);
        return new LngLat(array[1], array[0]);
    }

    //经度,纬度 字符串
    public static LngLat parseLngLat(String lngLatStr) {
        if (StringUtils.isEmpty(lngLatStr) || !lngLatStr.contains(SPLITER)) {
            return null;
        }
        String[] array = lngLatStr.split(SPLITER);
        return new LngLat(array[0], array[1]);
    }


    @Override
    public String toString() {
        return toLatLngString();
    }

    /**
     * @return "纬度,经度" 字符串
     */
    public String toLatLngString() {
        return lat + SPLITER + lng;
    }

    /**
     * @return "经度,纬度" 字符串
     */
    public String toLngLatString() {
        return lng + SPLITER + lat;
    }


    public double getLng() {
        return lng;
    }

    public void setLng(double lng) {
        this.lng = lng;
    }

    public double getLat() {
        return lat;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }
}