package com.rocogz.syy.common.aliyunoss.config;

import com.rocogz.syy.common.aliyunoss.service.UploadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 配置上传阿里云
 * @author ：liangyongtong
 * @since ：2020/3/28
 */
@Configuration
@ConditionalOnMissingBean(UploadService.class)
@EnableConfigurationProperties(AliyunOssProperties.class)
@ConditionalOnProperty(prefix = "aliyun.oss.config", name = "isopen", havingValue = "true")
public class AliyunOssConfig {

    @Autowired
    private AliyunOssProperties ssoProperties;

    @Bean
    public UploadService uploadService() {
        return new UploadService(ssoProperties);
    }
}
