package com.rocogz.syy.common.tencent;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * 距离和时间
 * @author zhangmin
 * @date 2020/4/8
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class DistanceTime {

    /**
     * 起点到终点的距离，单位：米
     */
    private Integer distance;

    /**
     * 表示从起点到终点的结合路况的时间，秒为单位
     *
     * 注：步行/骑行方式不计算耗时，该值始终为0
     */
    private Integer duration;


    /**
     * 目的地经纬度
     */
    private LngLat dest;


    public Integer getDistance() {
        return distance;
    }

    public void setDistance(Integer distance) {
        this.distance = distance;
    }

    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }


    public LngLat getDest() {
        return dest;
    }

    public void setDest(LngLat dest) {
        this.dest = dest;
    }
}
