package com.rocogz.syy.common.tencent.resp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.rocogz.syy.common.tencent.DistanceTime;
import com.rocogz.syy.common.tencent.LngLat;

import java.util.List;

/**
 * 多出发地 -> 多目的的计算返回结果，返回的结果 是二维数组
 * @author zhangmin
 * @date 2020/4/8
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class QQMultiOriginMultiDestDistanceResp extends QQMapBaseResp {

    private MultiOriginDistance result;

    public MultiOriginDistance getResult() {
        return result;
    }

    public void setResult(MultiOriginDistance result) {
        this.result = result;
    }

    public static class MultiOriginDistance {

        @JsonProperty("rows")
        private List<OneOriginDistance> originDistanceList;

        public List<OneOriginDistance> getOriginDistanceList() {
            return originDistanceList;
        }

        public void setOriginDistanceList(List<OneOriginDistance> originDistanceList) {
            this.originDistanceList = originDistanceList;
        }
    }

    /**
     * 一个出发地的 包含的结算结果
     */
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class OneOriginDistance {

        /**
         * 出发地经纬度
         */
        private LngLat origin;

        /**
         * 到达目的地的距离集合
         */
        @JsonProperty("elements")
        private List<DistanceTime>  distanceList;


        public LngLat getOrigin() {
            return origin;
        }

        public void setOrigin(LngLat origin) {
            this.origin = origin;
        }

        public List<DistanceTime> getDistanceList() {
            return distanceList;
        }

        public void setDistanceList(List<DistanceTime> distanceList) {
            this.distanceList = distanceList;
        }
    }


}
