package com.rocogz.syy.common.web;


import com.rocogz.syy.common.web.convevter.LocalDateConverter;
import com.rocogz.syy.common.web.convevter.LocalDateTimeConverter;
import com.rocogz.syy.common.web.convevter.LocalTimeConverter;
import com.rocogz.syy.common.web.convevter.YearMonthConverter;
import org.springframework.context.annotation.Configuration;
import org.springframework.format.FormatterRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author zhangmin
 * @date 2020/4/12
 */
@Configuration
public class WebMvcConfig implements WebMvcConfigurer {

    /**
     * （1）对于 @RequestParam 接收的日期数据，注册了 日期格式转换器
     *  (2)对于 x-www-form-urlencoded 表单数据,进行日期格式转换
     * @param registry
     */
    @Override
    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter(new LocalDateConverter());
        registry.addConverter(new YearMonthConverter());
        registry.addConverter(new LocalTimeConverter());
        registry.addConverter(new LocalDateTimeConverter());
    }

}
