package com.rocogz.syy.common.web.convevter;

import org.springframework.core.convert.converter.Converter;
import org.springframework.util.StringUtils;

import javax.validation.ValidationException;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;

/**
 * 时间格式：HH:mm:ss (24小时制）
 * @author zhangmin
 * @date 2020/4/12
 */
public class LocalTimeConverter implements Converter<String,LocalTime> {
    @Override
    public LocalTime convert(String source) {
        if(StringUtils.isEmpty(source)) {
            return null;
        }

        try {
            return LocalTime.parse(source);
        } catch (DateTimeParseException ex) {
            throw new ValidationException("时间格式不正确，输入的时间是：" + source);
        }
    }


}
